/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.filter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.Validate;

public class Filter
implements Predicate<ItemStack> {
    public static final int FILTER_SIZE = 9;
    private final ModuleFlags flags;
    private final List<IItemMatcher> matchers = Lists.newArrayList();
    private final List<ItemStack> rawStacks = Lists.newArrayList();
    private final boolean roundRobin;
    private int rrCounter = 0;

    public Filter() {
        this.flags = ModuleFlags.DEFAULT;
        this.roundRobin = false;
    }

    public Filter(ItemStack moduleStack, boolean storeRaw, boolean roundRobin) {
        Validate.isTrue((boolean)(moduleStack.getItem() instanceof ModuleItem), (String)("item stack is not a module item! " + String.valueOf(moduleStack.getItem())), (Object[])new Object[0]);
        this.roundRobin = roundRobin;
        this.rrCounter = roundRobin ? ModuleItem.getRoundRobinCounter(moduleStack) : 0;
        this.flags = ModuleFlags.forItem(moduleStack);
        BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(moduleStack, null);
        for (int i = 0; i < filterHandler.getSlots(); ++i) {
            ItemStack filterStack = filterHandler.getStackInSlot(i);
            if (filterStack.isEmpty()) continue;
            IItemMatcher matcher = this.createMatcher(filterStack, moduleStack);
            this.matchers.add(matcher);
            if (!storeRaw) continue;
            this.rawStacks.add(filterStack);
        }
        if (roundRobin && this.rrCounter >= this.matchers.size()) {
            this.rrCounter = 0;
        }
    }

    @Nonnull
    private IItemMatcher createMatcher(ItemStack filterStack, ItemStack moduleStack) {
        Item item = filterStack.getItem();
        if (item instanceof SmartFilterItem) {
            SmartFilterItem sf = (SmartFilterItem)item;
            return sf.compile(filterStack, moduleStack);
        }
        return ((ModuleItem)moduleStack.getItem()).getFilterItemMatcher(filterStack);
    }

    public List<ItemStack> getRawStacks() {
        return this.rawStacks;
    }

    public boolean isEmpty() {
        return this.matchers.isEmpty();
    }

    public boolean isWhiteList() {
        return this.flags.whiteList();
    }

    @Override
    public boolean test(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (this.roundRobin && !this.matchers.isEmpty()) {
            return this.matchers.get(this.rrCounter).matchItem(stack, this.flags) == this.flags.whiteList();
        }
        boolean matchAll = this.flags.matchAllItems();
        for (IItemMatcher matcher : this.matchers) {
            boolean matchedOne = matcher.matchItem(stack, this.flags);
            if ((matchAll || !matchedOne) && (!matchAll || matchedOne)) continue;
            return matchAll != this.flags.whiteList();
        }
        return matchAll == this.flags.whiteList();
    }

    public Optional<Integer> cycleRoundRobin() {
        if (this.roundRobin && ++this.rrCounter >= this.matchers.size()) {
            this.rrCounter = 0;
        }
        return this.roundRobin ? Optional.of(this.rrCounter) : Optional.empty();
    }

    public boolean testFluid(Fluid fluid) {
        for (IItemMatcher matcher : this.matchers) {
            if (!matcher.matchFluid(fluid, this.flags)) continue;
            return this.flags.whiteList();
        }
        return !this.flags.whiteList();
    }

    public ModuleFlags getFlags() {
        return this.flags;
    }
}

