/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class CompiledEnergyDistributorModule
extends CompiledModule {
    public CompiledEnergyDistributorModule(@Nullable ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        List<ModuleTarget> inRange = this.getTargets().stream().filter(target -> target.isSameWorld(router.getLevel()) && router.getBlockPos().distSqr((Vec3i)target.gPos.pos()) <= (double)this.getRangeSquared()).toList();
        if (inRange.isEmpty()) {
            return false;
        }
        int total = 0;
        IEnergyStorage storage = router.getEnergyStorage();
        if (storage != null) {
            int toSend = storage.getEnergyStored() / inRange.size();
            boolean doBeam = router.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 2;
            for (ModuleTarget target2 : inRange) {
                total += target2.getEnergyHandler().map(handler -> {
                    int toExtract = storage.extractEnergy(toSend, true);
                    int sent = handler.receiveEnergy(toExtract, false);
                    storage.extractEnergy(sent, false);
                    if (sent > 0 && doBeam) {
                        router.addItemBeam(new BeamData.Builder(router, target.gPos.pos(), -532660160).build());
                    }
                    return sent;
                }).orElse(0).intValue();
            }
        }
        return total > 0;
    }

    @Override
    public List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        return router == null ? List.of() : ImmutableList.copyOf(TargetedModule.getTargets(stack, !router.getLevel().isClientSide));
    }
}

