/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class ModuleTarget {
    public final GlobalPos gPos;
    public final Direction face;
    public final String blockTranslationKey;
    private BlockCapabilityCache<IItemHandler, Direction> itemCapCache;
    private BlockCapabilityCache<IFluidHandler, Direction> fluidCapCache;
    private BlockCapabilityCache<IEnergyStorage, Direction> energyCapCache;
    public static final Codec<ModuleTarget> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(t -> t.gPos), (App)Direction.CODEC.fieldOf("face").forGetter(t -> t.face), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(t -> t.blockTranslationKey)).apply((Applicative)builder, ModuleTarget::new));
    public static final StreamCodec<FriendlyByteBuf, ModuleTarget> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, t -> t.gPos, (StreamCodec)Direction.STREAM_CODEC, t -> t.face, (StreamCodec)ByteBufCodecs.STRING_UTF8, t -> t.blockTranslationKey, ModuleTarget::new);

    public ModuleTarget(GlobalPos gPos, Direction face, String blockTranslationKey) {
        this.gPos = gPos;
        this.face = face;
        this.blockTranslationKey = blockTranslationKey;
    }

    public ModuleTarget(GlobalPos gPos, Direction face) {
        this(gPos, face, "");
    }

    public ModuleTarget(GlobalPos gPos) {
        this(gPos, null);
    }

    public boolean isSameWorld(@Nullable Level world) {
        return world != null && this.gPos.dimension() == world.dimension();
    }

    public boolean isSameWorld(ModuleTarget dst) {
        return this.gPos.dimension() == dst.gPos.dimension();
    }

    public boolean hasItemHandler(Level level) {
        return level.dimension().location().equals((Object)this.gPos.dimension().location()) && level.getCapability(Capabilities.ItemHandler.BLOCK, this.gPos.pos(), (Object)this.face) != null;
    }

    public Optional<IItemHandler> getItemHandler() {
        if (this.itemCapCache == null) {
            ServerLevel level = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (level == null) {
                return Optional.empty();
            }
            this.itemCapCache = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)level, (BlockPos)this.gPos.pos(), (Object)this.face);
        }
        return Optional.ofNullable((IItemHandler)this.itemCapCache.getCapability());
    }

    public Optional<IFluidHandler> getFluidHandler() {
        if (this.fluidCapCache == null) {
            ServerLevel level = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (level == null) {
                return Optional.empty();
            }
            this.fluidCapCache = BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)level, (BlockPos)this.gPos.pos(), (Object)this.face);
        }
        return Optional.ofNullable((IFluidHandler)this.fluidCapCache.getCapability());
    }

    public Optional<IEnergyStorage> getEnergyHandler() {
        if (this.energyCapCache == null) {
            ServerLevel level = MiscUtil.getWorldForGlobalPos(this.gPos);
            if (level == null) {
                return Optional.empty();
            }
            this.energyCapCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)this.gPos.pos(), (Object)this.face);
        }
        return Optional.ofNullable((IEnergyStorage)this.energyCapCache.getCapability());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleTarget)) {
            return false;
        }
        ModuleTarget that = (ModuleTarget)o;
        return this.gPos.equals((Object)that.gPos) && this.face == that.face;
    }

    public int hashCode() {
        return Objects.hash(this.gPos, this.face);
    }

    public String toString() {
        return MiscUtil.locToString(this.gPos) + " " + String.valueOf(this.face);
    }

    public Component getTextComponent() {
        return Component.translatable((String)this.blockTranslationKey).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)(" @ " + String.valueOf(this))).withStyle(ChatFormatting.AQUA));
    }
}

