/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.List;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.container.TagFilterMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.TagMatcher;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TagFilter
extends SmartFilterItem {
    public static List<TagKey<Item>> getTagList(ItemStack filterStack) {
        List strings = (List)filterStack.getOrDefault(ModDataComponents.FILTER_STRINGS, List.of());
        return strings.stream().filter(rl -> ResourceLocation.tryParse((String)rl) != null).map(s -> TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)s))).toList();
    }

    public static void setTagList(ItemStack filterStack, List<TagKey<Item>> tags) {
        filterStack.set(ModDataComponents.FILTER_STRINGS, tags.stream().map(t -> t.location().toString()).toList());
    }

    @Override
    @NotNull
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new TagMatcher(TagFilter.getTagList(filterStack));
    }

    @Override
    public void addExtraInformation(ItemStack stack, List<Component> list) {
        super.addExtraInformation(stack, list);
        List<TagKey<Item>> l = TagFilter.getTagList(stack);
        this.addCountInfo(list, l.size());
        list.addAll(l.stream().map(s -> " \u2022 " + String.valueOf(ChatFormatting.AQUA) + String.valueOf(s.location())).map(Component::literal).toList());
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return TagFilter.getTagList(filterStack).size();
    }

    @Override
    public AbstractSmartFilterMenu createMenu(int windowId, Inventory invPlayer, MFLocator loc) {
        return new TagFilterMenu(windowId, invPlayer, loc);
    }
}

