/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.container.BulkItemFilterMenu;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.BulkItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BulkItemFilter
extends SmartFilterItem {
    public static final int FILTER_SIZE = 54;

    @Override
    @NotNull
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        ModuleFlags flags = ModuleFlags.forItem(moduleStack);
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, flags);
        return new BulkItemMatcher(stacks, flags);
    }

    private static SetofItemStack getFilterItems(ItemStack filterStack, ModuleFlags flags) {
        BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack, null);
        return SetofItemStack.fromItemHandler((IItemHandler)handler, flags);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        super.addExtraInformation(itemstack, list);
        this.addCountInfo(list, this.getSize(itemstack));
    }

    @Override
    public AbstractSmartFilterMenu createMenu(int windowId, Inventory invPlayer, MFLocator loc) {
        return new BulkItemFilterMenu(windowId, invPlayer, loc);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        return ctx.getLevel().isClientSide ? InteractionResult.SUCCESS : this.handleUseServerSide(ctx);
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return BaseModuleHandler.getFilterItemCount(filterStack);
    }

    private InteractionResult handleUseServerSide(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Optional<IItemHandler> inventory = InventoryUtils.getInventory(ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace());
            if (inventory.isPresent()) {
                int nAdded = this.mergeInventory(ctx.getItemInHand(), inventory.get());
                sp.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.inventoryMerged", (Object[])new Object[]{nAdded, ctx.getItemInHand().getHoverName()}), false);
                ctx.getLevel().playSound(null, ctx.getClickedPos(), ModSounds.SUCCESS.get(), SoundSource.MASTER, ((Double)ConfigHolder.client.sound.bleepVolume.get()).floatValue(), 1.0f);
            } else {
                MFLocator loc = MFLocator.heldFilter(ctx.getHand());
                sp.openMenu((MenuProvider)new SmartFilterItem.FilterMenuProvider((Player)sp, loc), loc::toNetwork);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private int mergeInventory(ItemStack filterStack, IItemHandler srcInventory) {
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, ModuleFlags.DEFAULT);
        int origSize = stacks.size();
        for (int i = 0; i < srcInventory.getSlots() && stacks.size() < 54; ++i) {
            ItemStack stack = srcInventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack.copyWithCount(1));
        }
        BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack, null);
        int slot = 0;
        Comparator comp = (s1, s2) -> s1.getHoverName().toString().compareTo(s2.getHoverName().getString());
        for (ItemStack stack : stacks.stream().sorted(comp).toList()) {
            handler.setStackInSlot(slot++, stack);
        }
        handler.save();
        return stacks.size() - origSize;
    }
}

