/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.ModuleTargetList;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public abstract class TargetedModule
extends ModuleItem {
    protected TargetedModule(Item.Properties props, BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler) {
        super(props.component(ModDataComponents.MODULE_TARGET_LIST, (Object)ModuleTargetList.EMPTY), compiler);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getPlayer() != null && ctx.getPlayer().isCrouching()) {
            if (this.isValidTarget(ctx)) {
                if (this.getMaxTargets() == 1) {
                    this.handleSingleTarget(ctx.getItemInHand(), ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace());
                } else {
                    this.handleMultiTarget(ctx.getItemInHand(), ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace());
                }
                return InteractionResult.SUCCESS;
            }
            return super.useOn(ctx);
        }
        return InteractionResult.PASS;
    }

    protected boolean isValidTarget(UseOnContext ctx) {
        return InventoryUtils.getInventory(ctx.getLevel(), ctx.getClickedPos(), ctx.getClickedFace()).isPresent();
    }

    private void handleSingleTarget(ItemStack stack, Player player, Level world, BlockPos pos, Direction face) {
        if (!world.isClientSide) {
            TargetedModule.setTarget(stack, world, pos, face);
            ModuleTarget tgt = TargetedModule.getTarget(stack, true);
            if (tgt != null) {
                MutableComponent msg = Component.translatable((String)"modularrouters.chatText.misc.targetSet").append(tgt.getTextComponent());
                player.displayClientMessage((Component)msg.withStyle(ChatFormatting.YELLOW), true);
                world.playSound(null, pos, ModSounds.SUCCESS.get(), SoundSource.BLOCKS, ((Double)ConfigHolder.client.sound.bleepVolume.get()).floatValue(), 1.3f);
            }
        }
    }

    private void handleMultiTarget(ItemStack stack, Player player, Level world, BlockPos pos, Direction face) {
        if (!world.isClientSide) {
            boolean removing = false;
            String invName = BlockUtil.getBlockName(world, pos);
            GlobalPos gPos = MiscUtil.makeGlobalPos(world, pos);
            ModuleTarget tgt = new ModuleTarget(gPos, face, invName);
            Set<ModuleTarget> targets = TargetedModule.getTargets(stack, true);
            if (targets.contains(tgt)) {
                targets.remove(tgt);
                removing = true;
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.targetRemoved", (Object[])new Object[]{targets.size(), this.getMaxTargets()}).append(tgt.getTextComponent()).withStyle(ChatFormatting.YELLOW), true);
            } else if (targets.size() < this.getMaxTargets()) {
                targets.add(tgt);
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.targetAdded", (Object[])new Object[]{targets.size(), this.getMaxTargets()}).append(tgt.getTextComponent()).withStyle(ChatFormatting.YELLOW), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.tooManyTargets", (Object[])new Object[]{this.getMaxTargets()}).withStyle(ChatFormatting.RED), true);
                world.playSound(null, pos, ModSounds.ERROR.get(), SoundSource.BLOCKS, 1.0f, 1.3f);
                return;
            }
            world.playSound(null, pos, ModSounds.SUCCESS.get(), SoundSource.BLOCKS, ((Double)ConfigHolder.client.sound.bleepVolume.get()).floatValue(), removing ? 1.1f : 1.3f);
            TargetedModule.setTargetList(stack, targets);
        }
    }

    @Override
    public void addUsageInformation(ItemStack itemstack, List<Component> list) {
        super.addUsageInformation(itemstack, list);
        list.add((Component)ClientUtil.xlate(this.getMaxTargets() > 1 ? "modularrouters.itemText.targetingHintMulti" : "modularrouters.itemText.targetingHint", new Object[0]).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    protected void addSettingsInformation(ItemStack stack, List<Component> list) {
        super.addSettingsInformation(stack, list);
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(stack, false) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(stack)});
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            MutableComponent msg = Component.literal((String)"\u25b6 ").append((Component)MiscUtil.asMutableComponent(target.getTextComponent()).withStyle(ChatFormatting.WHITE));
            list.add((Component)msg);
            ClientUtil.getOpenItemRouter().ifPresent(router -> {
                ModuleTarget moduleTarget = new ModuleTarget(router.getGlobalPos());
                TargetValidation val = this.validateTarget(stack, moduleTarget, target, false);
                if (val != TargetValidation.OK) {
                    list.add((Component)ClientUtil.xlate(val.translationKey(), new Object[0]).withStyle(val.getColor()));
                }
            });
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> onSneakRightClick(ItemStack stack, Level world, Player player, InteractionHand hand) {
        if (!world.isClientSide && TargetedModule.getTarget(stack) != null && this.getMaxTargets() == 1) {
            TargetedModule.setTarget(stack, world, null, null);
            world.playSound(null, player.blockPosition(), ModSounds.SUCCESS.get(), SoundSource.BLOCKS, ((Double)ConfigHolder.client.sound.bleepVolume.get()).floatValue(), 1.1f);
            player.displayClientMessage((Component)Component.translatable((String)"modularrouters.chatText.misc.targetCleared").withStyle(ChatFormatting.YELLOW), true);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private static void setTarget(ItemStack stack, Level world, BlockPos pos, Direction face) {
        if (world.isClientSide) {
            ModularRouters.LOGGER.warn("TargetModule.setTarget() should not be called client-side!");
            return;
        }
        if (pos == null) {
            stack.set(ModDataComponents.MODULE_TARGET_LIST, (Object)ModuleTargetList.EMPTY);
        } else {
            ModuleTarget mt = new ModuleTarget(MiscUtil.makeGlobalPos(world, pos), face, BlockUtil.getBlockName(world, pos));
            stack.set(ModDataComponents.MODULE_TARGET_LIST, (Object)ModuleTargetList.singleTarget(mt));
        }
    }

    public static ModuleTarget getTarget(ItemStack stack) {
        return TargetedModule.getTarget(stack, false);
    }

    public static ModuleTarget getTarget(ItemStack stack, boolean checkBlockName) {
        ModuleTargetList targetList = (ModuleTargetList)stack.getOrDefault(ModDataComponents.MODULE_TARGET_LIST, (Object)ModuleTargetList.EMPTY);
        if (!targetList.isEmpty()) {
            return checkBlockName ? TargetedModule.updateTargetBlockName(stack, targetList.getSingle()) : targetList.getSingle();
        }
        return null;
    }

    public static Set<ModuleTarget> getTargets(ItemStack stack, boolean checkBlockName) {
        HashSet result = Sets.newHashSet();
        ((ModuleTargetList)stack.getOrDefault(ModDataComponents.MODULE_TARGET_LIST, (Object)ModuleTargetList.EMPTY)).targets().forEach(target -> {
            if (checkBlockName) {
                target = TargetedModule.updateTargetBlockName(stack, target);
            }
            if (target != null) {
                result.add(target);
            }
        });
        return result;
    }

    private static void setTargetList(ItemStack stack, Set<ModuleTarget> targets) {
        stack.set(ModDataComponents.MODULE_TARGET_LIST, (Object)new ModuleTargetList(List.copyOf(targets)));
    }

    private static ModuleTarget updateTargetBlockName(ItemStack stack, ModuleTarget target) {
        ServerLevel level = MiscUtil.getWorldForGlobalPos(target.gPos);
        BlockPos pos = target.gPos.pos();
        if (level != null && level.getChunkSource().hasChunk(pos.getX() >> 4, pos.getZ() >> 4)) {
            String invName = BlockUtil.getBlockName((Level)level, pos);
            if (!target.blockTranslationKey.equals(invName)) {
                TargetedModule.setTarget(stack, (Level)level, pos, target.face);
                return new ModuleTarget(target.gPos, target.face, invName);
            }
            return target;
        }
        return null;
    }

    @Override
    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
        ModuleTarget src = new ModuleTarget(MiscUtil.makeGlobalPos(player.getCommandSenderWorld(), player.blockPosition()));
        HashSet targets = this.getMaxTargets() > 1 ? TargetedModule.getTargets(stack, true) : Sets.newHashSet((Object[])new ModuleTarget[]{TargetedModule.getTarget(stack, true)});
        for (ModuleTarget target : targets) {
            if (target == null) continue;
            TargetValidation v = this.validateTarget(stack, src, target, true);
            MutableComponent msg = MiscUtil.asMutableComponent(target.getTextComponent()).append(" ").append((Component)Component.translatable((String)v.translationKey()).withStyle(v.getColor()));
            player.displayClientMessage((Component)msg, false);
        }
    }

    private TargetValidation validateTarget(ItemStack moduleStack, ModuleTarget src, ModuleTarget dst, boolean validateBlocks) {
        if (this.isRangeLimited() && (!src.isSameWorld(dst) || src.gPos.pos().distSqr((Vec3i)dst.gPos.pos()) > (double)this.maxDistanceSq(moduleStack))) {
            return TargetValidation.OUT_OF_RANGE;
        }
        if (validateBlocks) {
            ServerLevel w = MiscUtil.getWorldForGlobalPos(dst.gPos);
            if (w == null || !w.getChunkSource().hasChunk(dst.gPos.pos().getX() >> 4, dst.gPos.pos().getZ() >> 4)) {
                return TargetValidation.NOT_LOADED;
            }
            if (w.getBlockEntity(dst.gPos.pos()) == null) {
                return TargetValidation.NOT_INVENTORY;
            }
            if (this.badDimension(dst.gPos.dimension().location()) || this.badDimension(src.gPos.dimension().location())) {
                return TargetValidation.BAD_DIMENSION;
            }
        }
        return TargetValidation.OK;
    }

    protected boolean badDimension(ResourceLocation dimId) {
        return false;
    }

    private int maxDistanceSq(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IRangedModule) {
            IRangedModule rangedModule = (IRangedModule)item;
            int r = rangedModule.getCurrentRange(stack);
            return r * r;
        }
        return 0;
    }

    protected int getMaxTargets() {
        return 1;
    }

    protected boolean isRangeLimited() {
        return true;
    }

    static enum TargetValidation implements StringRepresentable
    {
        OK("ok"),
        OUT_OF_RANGE("out_of_range"),
        NOT_LOADED("not_loaded"),
        NOT_INVENTORY("no_inventory"),
        BAD_DIMENSION("bad_dimension");

        private final String name;

        private TargetValidation(String name) {
            this.name = name;
        }

        ChatFormatting getColor() {
            return this == OK ? ChatFormatting.GREEN : ChatFormatting.RED;
        }

        String translationKey() {
            return "modularrouters.chatText.targetValidation." + this.getSerializedName();
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

