/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.IPlayerOwned;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.compiled.CompiledPlayerModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.UseOnContext;

public class PlayerModule
extends ModuleItem
implements IPlayerOwned {
    private static final TintColor TINT_COLOR = new TintColor(255, 208, 144);

    public PlayerModule() {
        super(ModItems.moduleProps().component(ModDataComponents.PLAYER_SETTINGS, (Object)CompiledPlayerModule.PlayerSettings.DEFAULT), CompiledPlayerModule::new);
    }

    @Override
    public void addSettingsInformation(ItemStack stack, List<Component> list) {
        super.addSettingsInformation(stack, list);
        CompiledPlayerModule.PlayerSettings settings = (CompiledPlayerModule.PlayerSettings)stack.getOrDefault(ModDataComponents.PLAYER_SETTINGS, (Object)CompiledPlayerModule.PlayerSettings.DEFAULT);
        ResolvableProfile profile = (ResolvableProfile)stack.get(ModDataComponents.OWNER);
        String owner = profile == null ? "-" : profile.gameProfile().getName();
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.security.owner", ClientUtil.colorText(owner, ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW));
        MutableComponent c = ClientUtil.xlate("modularrouters.itemText.misc.operation", new Object[0]).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)ClientUtil.xlate("block.modularrouters.modular_router", new Object[0]).append(" ").append(settings.direction().getSymbol()).append(" ").append((Component)ClientUtil.xlate(settings.section().getTranslationKey(), new Object[0])).withStyle(ChatFormatting.AQUA));
        list.add((Component)c);
    }

    @Override
    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.PLAYER_MENU.get();
    }

    @Override
    public boolean isDirectional() {
        return false;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (ctx.getPlayer() != null && ctx.getPlayer().isSteppingCarefully()) {
            this.setOwner(ctx.getItemInHand(), ctx.getPlayer());
            ctx.getPlayer().displayClientMessage((Component)Component.translatable((String)"modularrouters.itemText.security.owner", (Object[])new Object[]{ctx.getPlayer().getDisplayName()}), false);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        return (Integer)ConfigHolder.common.energyCosts.playerModuleEnergyCost.get();
    }

    @Override
    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
        TargetedModule.TargetValidation v = ModularRouters.getDimensionBlacklist().test(player.level().dimension().location()) ? TargetedModule.TargetValidation.BAD_DIMENSION : TargetedModule.TargetValidation.OK;
        MutableComponent msg = Component.translatable((String)v.translationKey()).withStyle(v.getColor());
        player.displayClientMessage((Component)msg, false);
    }
}

