/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.ClientSetup;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.container.RouterMenu;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.MRBaseItem;
import me.desht.modularrouters.item.augment.AugmentItem;
import me.desht.modularrouters.item.module.IPickaxeUser;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.SimpleItemMatcher;
import me.desht.modularrouters.logic.settings.ModuleFlags;
import me.desht.modularrouters.logic.settings.ModuleSettings;
import me.desht.modularrouters.logic.settings.ModuleTermination;
import me.desht.modularrouters.logic.settings.RedstoneBehaviour;
import me.desht.modularrouters.logic.settings.RelativeDirection;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class ModuleItem
extends MRBaseItem
implements ModItems.ITintable {
    private final BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler;

    public ModuleItem(Item.Properties props, BiFunction<ModularRouterBlockEntity, ItemStack, ? extends CompiledModule> compiler) {
        super(props);
        this.compiler = compiler;
    }

    public static ModuleSettings getCommonSettings(ItemStack moduleStack) {
        return (ModuleSettings)moduleStack.getOrDefault(ModDataComponents.COMMON_MODULE_SETTINGS, (Object)ModuleSettings.DEFAULT);
    }

    public static void setRoundRobinCounter(ItemStack moduleStack, int counter) {
        moduleStack.set(ModDataComponents.RR_COUNTER, (Object)counter);
    }

    public static int getRoundRobinCounter(ItemStack moduleStack) {
        return (Integer)moduleStack.getOrDefault(ModDataComponents.RR_COUNTER, (Object)0);
    }

    public static RedstoneBehaviour getRedstoneBehaviour(ItemStack moduleStack) {
        return ModuleItem.getCommonSettings(moduleStack).redstoneBehaviour();
    }

    public static int getRangeModifier(ItemStack stack) {
        AugmentItem.AugmentCounter counter = new AugmentItem.AugmentCounter(stack);
        return counter.getAugmentCount((Item)ModItems.RANGE_UP_AUGMENT.get()) - counter.getAugmentCount((Item)ModItems.RANGE_DOWN_AUGMENT.get());
    }

    public final CompiledModule compile(ModularRouterBlockEntity router, ItemStack stack) {
        return this.compiler.apply(router, stack);
    }

    @Override
    public abstract TintColor getItemTint();

    public boolean isDirectional() {
        return true;
    }

    public boolean isOmniDirectional() {
        return false;
    }

    public boolean isFluidModule() {
        return false;
    }

    ModuleMenu createContainer(int windowId, Inventory invPlayer, MFLocator loc) {
        return new ModuleMenu(this.getMenuType(), windowId, invPlayer, loc);
    }

    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.BASE_MODULE_MENU.get();
    }

    public boolean isItemValidForFilter(ItemStack stack) {
        return true;
    }

    @Nonnull
    public IItemMatcher getFilterItemMatcher(ItemStack stack) {
        return new SimpleItemMatcher(stack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, context, list, flag);
        if (ClientUtil.getHoveredSlot() instanceof RouterMenu.InstalledModuleSlot && !ClientUtil.isKeyDown(ClientSetup.keybindModuleInfo)) {
            MutableComponent key = ClientSetup.keybindConfigure.getKey().getDisplayName().copy().withStyle(ChatFormatting.DARK_AQUA);
            MutableComponent middleClick = Component.literal((String)"Middle-Click").withStyle(ChatFormatting.DARK_AQUA);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.configureHint", key, middleClick).withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<Component> list) {
        this.addSettingsInformation(stack, list);
        this.addAugmentInformation(stack, list);
    }

    protected void addSettingsInformation(ItemStack stack, List<Component> list) {
        int energy;
        ModuleTermination termination;
        ModuleItem col;
        ModuleSettings settings = ModuleItem.getCommonSettings(stack);
        if (this.isDirectional()) {
            MutableComponent dirStr = this.getDirectionString(settings.facing());
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.label.direction", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)": ")).append((Component)dirStr.withStyle(ChatFormatting.AQUA)));
        }
        this.addFilterInformation(stack, list);
        ModuleFlags flags = ModuleFlags.forItem(stack);
        MutableComponent flagText = this.formatFlag("match_damage", flags.matchDamage()).append(" | ").append((Component)this.formatFlag("match_components", flags.matchComponents())).append(" | ").append((Component)this.formatFlag("match_item_tags", flags.matchItemTags()));
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.flags", new Object[0]).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)flagText));
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.match", new Object[0]).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)ClientUtil.xlate("modularrouters.itemText.misc." + (flags.matchAllItems() ? "matchAll" : "matchAny"), new Object[0]).withStyle(ChatFormatting.AQUA)));
        ModuleItem moduleItem = this;
        if (moduleItem instanceof IRangedModule) {
            IRangedModule rm = (IRangedModule)((Object)moduleItem);
            int curRange = rm.getCurrentRange(stack);
            col = curRange > rm.getBaseRange() ? ChatFormatting.GREEN : (curRange < rm.getBaseRange() ? ChatFormatting.RED : ChatFormatting.AQUA);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.rangeInfo", ClientUtil.colorText(rm.getCurrentRange(stack), new ChatFormatting[]{col}), ClientUtil.colorText(rm.getBaseRange(), ChatFormatting.AQUA), ClientUtil.colorText(rm.getHardMaxRange(), ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW));
        }
        if ((termination = settings.termination()) != ModuleTermination.NONE) {
            list.add((Component)ClientUtil.xlate(termination.getTranslationKey() + ".header", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
        if ((col = this) instanceof IPickaxeUser) {
            IPickaxeUser pickaxeUser = (IPickaxeUser)((Object)col);
            ItemStack pick = pickaxeUser.getPickaxe(stack);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.breakerPick", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)pick.getHoverName().plainCopy().withStyle(ChatFormatting.AQUA)));
            ((ItemEnchantments)pick.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet().forEach(holder -> list.add((Component)Component.literal((String)"\u25b6 ").append((Component)Enchantment.getFullname((Holder)((Holder)holder.getKey()), (int)holder.getIntValue()).copy().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW)));
        }
        if ((energy = this.getEnergyCost(stack)) != 0) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.energyUsage", ClientUtil.colorText(energy, ChatFormatting.AQUA)).withStyle(ChatFormatting.YELLOW));
        }
    }

    public abstract int getEnergyCost(ItemStack var1);

    private void addAugmentInformation(ItemStack stack, List<Component> list) {
        AugmentItem.AugmentCounter c = new AugmentItem.AugmentCounter(stack);
        ArrayList toAdd = Lists.newArrayList();
        for (AugmentItem augment : c.getAugments()) {
            int n = c.getAugmentCount(augment);
            if (n <= 0) continue;
            ItemStack augmentStack = new ItemStack((ItemLike)augment);
            MutableComponent comp = Component.literal((String)" \u2022 ").withStyle(ChatFormatting.DARK_GREEN).append((Component)(n > 1 ? Component.literal((String)(n + " x ")).append(augmentStack.getHoverName()) : augmentStack.getHoverName())).append((Component)augment.getExtraInfo(n, stack).copy().withStyle(ChatFormatting.DARK_AQUA));
            toAdd.add(comp);
        }
        if (!toAdd.isEmpty()) {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.augments", new Object[0]).withStyle(ChatFormatting.GREEN));
            list.addAll(toAdd);
        }
    }

    public MutableComponent getDirectionString(RelativeDirection dir) {
        return this.isOmniDirectional() && dir == RelativeDirection.NONE ? ClientUtil.xlate("modularrouters.guiText.tooltip.allDirections", new Object[0]) : ClientUtil.xlate(dir.getTranslationKey(), new Object[0]);
    }

    private MutableComponent formatFlag(String key, boolean flag) {
        return ClientUtil.xlate("modularrouters.itemText.misc." + key, new Object[0]).withStyle(flag ? ChatFormatting.AQUA : ChatFormatting.DARK_GRAY);
    }

    protected Component getFilterItemDisplayName(ItemStack stack) {
        return stack.getHoverName();
    }

    protected MutableComponent itemListHeader(ItemStack itemstack) {
        boolean whiteList = ModuleFlags.forItem(itemstack).whiteList();
        return ClientUtil.xlate("modularrouters.itemText.misc." + (whiteList ? "whitelist" : "blacklist"), new Object[0]).withStyle(ChatFormatting.YELLOW);
    }

    private void addFilterInformation(ItemStack itemstack, List<Component> list) {
        ArrayList<MutableComponent> l2 = new ArrayList<MutableComponent>();
        BaseModuleHandler.ModuleFilterHandler filterHandler = new BaseModuleHandler.ModuleFilterHandler(itemstack, null);
        for (int i = 0; i < filterHandler.getSlots(); ++i) {
            ItemStack s = filterHandler.getStackInSlot(i);
            Item item = s.getItem();
            if (item instanceof SmartFilterItem) {
                SmartFilterItem sf = (SmartFilterItem)item;
                int size = sf.getSize(s);
                Object suffix = size > 0 ? " [" + size + "]" : "";
                l2.add(Component.literal((String)" \u2022 ").append((Component)s.getHoverName().plainCopy().append((String)suffix)).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
                continue;
            }
            if (s.isEmpty()) continue;
            l2.add(Component.literal((String)" \u2022 ").append((Component)this.getFilterItemDisplayName(s).plainCopy().withStyle(ChatFormatting.AQUA)));
        }
        if (l2.isEmpty()) {
            list.add((Component)this.itemListHeader(itemstack).withStyle(ChatFormatting.YELLOW).append(": ").append((Component)ClientUtil.xlate("modularrouters.itemText.misc.noItems", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})));
        } else {
            list.add((Component)this.itemListHeader(itemstack).withStyle(ChatFormatting.YELLOW).append(": "));
            list.addAll(l2);
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isCrouching()) {
            if (!world.isClientSide) {
                MFLocator locator = MFLocator.heldModule(hand);
                player.openMenu((MenuProvider)new ModuleMenuProvider(player, locator), locator::toNetwork);
            }
        } else {
            return this.onSneakRightClick(stack, world, player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public boolean isFoil(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof IPickaxeUser) {
            IPickaxeUser pickaxeUser = (IPickaxeUser)item;
            ItemStack pick = pickaxeUser.getPickaxe(stack);
            return !pick.isEmpty() && EnchantmentHelper.hasAnyEnchantments((ItemStack)pick);
        }
        return false;
    }

    public String getRegulatorTranslationKey(ItemStack stack) {
        return "modularrouters.guiText.tooltip.regulator.label";
    }

    public InteractionResultHolder<ItemStack> onSneakRightClick(ItemStack stack, Level world, Player player, InteractionHand hand) {
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void doModuleValidation(ItemStack stack, ServerPlayer player) {
    }

    public static class ModuleMenuProvider
    implements MenuProvider {
        private final MFLocator loc;
        private final ItemStack moduleStack;

        public ModuleMenuProvider(Player player, MFLocator loc) {
            this.loc = loc;
            this.moduleStack = loc.getModuleStack(player);
        }

        public Component getDisplayName() {
            return this.moduleStack.getHoverName();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
            return ((ModuleItem)this.moduleStack.getItem()).createContainer(windowId, playerInventory, this.loc);
        }
    }
}

