/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.compiled.CompiledActivatorModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class ActivatorModule
extends ModuleItem {
    private static final TintColor TINT_COLOR = new TintColor(255, 255, 195);

    public ActivatorModule() {
        super(ModItems.moduleProps().component(ModDataComponents.ACTIVATOR_SETTINGS, (Object)CompiledActivatorModule.ActivatorSettings.DEFAULT), CompiledActivatorModule::new);
    }

    @Override
    public void addSettingsInformation(ItemStack stack, List<Component> list) {
        super.addSettingsInformation(stack, list);
        CompiledActivatorModule.ActivatorSettings settings = (CompiledActivatorModule.ActivatorSettings)stack.getOrDefault(ModDataComponents.ACTIVATOR_SETTINGS, (Object)CompiledActivatorModule.ActivatorSettings.DEFAULT);
        list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.action", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate(settings.actionType().getTranslationKey(), new Object[0]).withStyle(ChatFormatting.AQUA)));
        if (!settings.actionType().isEntityTarget()) {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.lookDirection", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate(settings.lookDirection().getTranslationKey(), new Object[0]).withStyle(ChatFormatting.AQUA)));
        } else {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.entityMode", new Object[0]).append(": ").withStyle(ChatFormatting.YELLOW).append((Component)ClientUtil.xlate(settings.entityMode().getTranslationKey(), new Object[0]).withStyle(ChatFormatting.AQUA)));
        }
        if (settings.sneaking()) {
            list.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.sneak", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        CompiledActivatorModule.ActivatorSettings settings = (CompiledActivatorModule.ActivatorSettings)stack.get(ModDataComponents.ACTIVATOR_SETTINGS);
        return settings.actionType() == CompiledActivatorModule.ActionType.ATTACK_ENTITY ? (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCostAttack.get() : (Integer)ConfigHolder.common.energyCosts.activatorModuleEnergyCost.get();
    }

    @Override
    public MenuType<? extends ModuleMenu> getMenuType() {
        return ModMenuTypes.ACTIVATOR_MENU.get();
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }
}

