/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.module;

import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.client.gui.widgets.button.ItemStackCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedCyclerButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedToggleButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.logic.compiled.CompiledActivatorModule;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ActivatorModuleScreen
extends ModuleScreen {
    private static final ItemStack ITEM_STACK = new ItemStack((ItemLike)Items.FLINT_AND_STEEL);
    private static final ItemStack ENTITY_STACK = new ItemStack((ItemLike)Items.PLAYER_HEAD);
    private static final ItemStack ATTACK_STACK = new ItemStack((ItemLike)Items.IRON_SWORD);
    private LookDirectionButton lookDirectionButton;
    private ItemStackCyclerButton<CompiledActivatorModule.ActionType> actionTypeButton;
    private EntityModeButton entityModeButton;
    private SneakButton sneakButton;

    public ActivatorModuleScreen(ModuleMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
    }

    @Override
    public void init() {
        super.init();
        CompiledActivatorModule cam = new CompiledActivatorModule(null, this.moduleItemStack);
        ItemStack[] stacks = new ItemStack[]{ITEM_STACK, ENTITY_STACK, ATTACK_STACK};
        this.actionTypeButton = new ItemStackCyclerButton<CompiledActivatorModule.ActionType>(this.leftPos + 167, this.topPos + 20, 16, 16, false, stacks, cam.getActionType(), this);
        this.addRenderableWidget((GuiEventListener)this.actionTypeButton);
        this.sneakButton = new SneakButton(this, this.leftPos + 167, this.topPos + 40, cam.isSneaking());
        this.addRenderableWidget((GuiEventListener)this.sneakButton);
        this.lookDirectionButton = new LookDirectionButton(this, this.leftPos + 167, this.topPos + 60, 16, 16, cam.getLookDirection());
        this.addRenderableWidget((GuiEventListener)this.lookDirectionButton);
        this.entityModeButton = new EntityModeButton(this, this.leftPos + 167, this.topPos + 60, 16, 16, cam.getEntityMode());
        this.addRenderableWidget((GuiEventListener)this.entityModeButton);
        this.lookDirectionButton.visible = !cam.getActionType().isEntityTarget();
        this.entityModeButton.visible = cam.getActionType().isEntityTarget();
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 130, this.topPos + 18, this.leftPos + 183, this.topPos + 37, "modularrouters.guiText.popup.activator.action");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 130, this.topPos + 39, this.leftPos + 183, this.topPos + 56, "modularrouters.guiText.popup.activator.sneak");
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 130, this.topPos + 59, this.leftPos + 183, this.topPos + 76, "modularrouters.guiText.popup.activator.look", guiContainer -> this.lookDirectionButton.visible);
        this.getMouseOverHelp().addHelpRegion(this.leftPos + 130, this.topPos + 59, this.leftPos + 183, this.topPos + 76, "modularrouters.guiText.popup.activator.look", guiContainer -> this.entityModeButton.visible);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderLabels(graphics, mouseX, mouseY);
        graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.action", new Object[0]), 132, 23, 0x404040, false);
        graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.sneak", new Object[0]), 132, 43, 0x404040, false);
        if (this.actionTypeButton.getState().isEntityTarget()) {
            graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.entityMode", new Object[0]), 132, 63, 0x404040, false);
        } else {
            graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.tooltip.activator.lookDirection", new Object[0]), 132, 63, 0x404040, false);
        }
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.lookDirectionButton.visible = !this.actionTypeButton.getState().isEntityTarget();
        this.entityModeButton.visible = this.actionTypeButton.getState().isEntityTarget();
    }

    @Override
    protected ItemStack buildModifiedItemStack() {
        return (ItemStack)Util.make((Object)super.buildModifiedItemStack(), stack -> stack.set(ModDataComponents.ACTIVATOR_SETTINGS, (Object)new CompiledActivatorModule.ActivatorSettings(this.actionTypeButton.getState(), (CompiledActivatorModule.LookDirection)this.lookDirectionButton.getState(), (CompiledActivatorModule.EntityMode)this.entityModeButton.getState(), this.sneakButton.isToggled())));
    }

    private class SneakButton
    extends TexturedToggleButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(112, 16);
        private static final XYPoint TEXTURE_XY_TOGGLED = new XYPoint(192, 16);

        SneakButton(ActivatorModuleScreen activatorModuleScreen, int x, int y, boolean initialVal) {
            super(x, y, 16, 16, initialVal, activatorModuleScreen);
        }

        @Override
        protected XYPoint getTextureXY() {
            return this.isToggled() ? TEXTURE_XY_TOGGLED : TEXTURE_XY;
        }
    }

    private class LookDirectionButton
    extends TexturedCyclerButton<CompiledActivatorModule.LookDirection> {
        LookDirectionButton(ActivatorModuleScreen activatorModuleScreen, int x, int y, int width, int height, CompiledActivatorModule.LookDirection initialVal) {
            super(x, y, width, height, initialVal, activatorModuleScreen);
        }

        @Override
        protected XYPoint getTextureXY() {
            return new XYPoint(144 + ((CompiledActivatorModule.LookDirection)this.getState()).ordinal() * 16, 0);
        }
    }

    private class EntityModeButton
    extends TexturedCyclerButton<CompiledActivatorModule.EntityMode> {
        EntityModeButton(ActivatorModuleScreen activatorModuleScreen, int x, int y, int width, int height, CompiledActivatorModule.EntityMode initialVal) {
            super(x, y, width, height, initialVal, activatorModuleScreen);
        }

        @Override
        protected XYPoint getTextureXY() {
            int x = switch ((CompiledActivatorModule.EntityMode)this.getState()) {
                default -> throw new MatchException(null, null);
                case CompiledActivatorModule.EntityMode.RANDOM -> 176;
                case CompiledActivatorModule.EntityMode.NEAREST -> 192;
                case CompiledActivatorModule.EntityMode.ROUND_ROBIN -> 160;
            };
            int y = switch ((CompiledActivatorModule.EntityMode)this.getState()) {
                default -> throw new MatchException(null, null);
                case CompiledActivatorModule.EntityMode.RANDOM, CompiledActivatorModule.EntityMode.ROUND_ROBIN -> 32;
                case CompiledActivatorModule.EntityMode.NEAREST -> 16;
            };
            return new XYPoint(x, y);
        }
    }
}

