/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import java.util.function.Consumer;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.gui.filter.AbstractFilterContainerScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.gui.widgets.button.TexturedButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.XYPoint;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.network.messages.BulkFilterUpdateMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BulkItemFilterScreen
extends AbstractFilterContainerScreen {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/bulkitemfilter.png");
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 233;
    private ModuleTarget target;

    public BulkItemFilterScreen(AbstractSmartFilterMenu container, Inventory inventory, Component displayName) {
        super(container, inventory, displayName);
        this.imageWidth = 176;
        this.imageHeight = 233;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ClearButton(this.leftPos + 8, this.topPos + 130, p -> PacketDistributor.sendToServer((CustomPacketPayload)BulkFilterUpdateMessage.untargeted(BulkFilterUpdateMessage.FilterOp.CLEAR_ALL, ((AbstractSmartFilterMenu)this.menu).getLocator()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        MFLocator locator = ((AbstractSmartFilterMenu)this.menu).getLocator();
        if (locator.filterSlot() >= 0) {
            this.addRenderableWidget((GuiEventListener)new BackButton(this.leftPos + 2, this.topPos + 2, p -> this.closeGUI()));
        }
        if (locator.routerSlot() >= 0 && locator.routerPos() != null) {
            ItemStack moduleStack = locator.getModuleStack((Player)Minecraft.getInstance().player);
            ModularRouterBlockEntity router = ((AbstractSmartFilterMenu)this.menu).getRouter();
            CompiledModule cm = ((ModuleItem)moduleStack.getItem()).compile(router, moduleStack);
            this.target = cm.getEffectiveTarget(router);
            if (this.target.hasItemHandler((Level)Minecraft.getInstance().level)) {
                MutableComponent title = ClientUtil.xlate(this.target.blockTranslationKey, new Object[0]);
                this.addRenderableWidget((GuiEventListener)new MergeButton(this.leftPos + 28, this.topPos + 130, this.target.toString(), (Component)title, p -> {
                    if (this.target != null) {
                        PacketDistributor.sendToServer((CustomPacketPayload)BulkFilterUpdateMessage.targeted(BulkFilterUpdateMessage.FilterOp.MERGE, ((AbstractSmartFilterMenu)this.menu).getLocator(), this.target), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }));
                this.addRenderableWidget((GuiEventListener)new LoadButton(this.leftPos + 48, this.topPos + 130, this.target.toString(), (Component)title, p -> {
                    if (this.target != null) {
                        PacketDistributor.sendToServer((CustomPacketPayload)BulkFilterUpdateMessage.targeted(BulkFilterUpdateMessage.FilterOp.LOAD, ((AbstractSmartFilterMenu)this.menu).getLocator(), this.target), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }));
            }
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, this.imageWidth / 2 - this.font.width(this.title) / 2, 8, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(TEXTURE_LOCATION, this.leftPos, this.topPos, 0, 0, 176, 233);
    }

    static class ClearButton
    extends Buttons.DeleteButton {
        ClearButton(int x, int y, Consumer<Buttons.DeleteButton> pressable) {
            super(x, y, 0, pressable);
            this.setTooltip(Tooltip.create((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.clearFilter", new Object[0])));
        }
    }

    static class MergeButton
    extends Buttons.AddButton {
        MergeButton(int x, int y, String locStr, Component name, Button.OnPress pressable) {
            super(x, y, pressable);
            this.setTooltip(Tooltip.create((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.mergeFilter", name.copy().withStyle(ChatFormatting.YELLOW), locStr)));
        }
    }

    static class LoadButton
    extends TexturedButton {
        private static final XYPoint TEXTURE_XY = new XYPoint(144, 16);

        LoadButton(int x, int y, String locStr, Component name, Button.OnPress pressable) {
            super(x, y, 16, 16, pressable);
            this.setTooltip(Tooltip.create((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.loadFilter", name.copy().withStyle(ChatFormatting.YELLOW), locStr)));
        }

        @Override
        protected XYPoint getTextureXY() {
            return TEXTURE_XY;
        }
    }
}

