/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client;

import com.mojang.blaze3d.platform.InputConstants;
import me.desht.modularrouters.client.gui.ModularRouterScreen;
import me.desht.modularrouters.client.gui.MouseOverHelp;
import me.desht.modularrouters.client.gui.filter.BulkItemFilterScreen;
import me.desht.modularrouters.client.gui.filter.FilterScreenFactory;
import me.desht.modularrouters.client.gui.filter.InspectionFilterScreen;
import me.desht.modularrouters.client.gui.filter.ModFilterScreen;
import me.desht.modularrouters.client.gui.filter.RegexFilterScreen;
import me.desht.modularrouters.client.gui.filter.TagFilterScreen;
import me.desht.modularrouters.client.gui.module.ActivatorModuleScreen;
import me.desht.modularrouters.client.gui.module.BreakerModuleScreen;
import me.desht.modularrouters.client.gui.module.DetectorModuleScreen;
import me.desht.modularrouters.client.gui.module.DistributorModuleScreen;
import me.desht.modularrouters.client.gui.module.ExtruderModule2Screen;
import me.desht.modularrouters.client.gui.module.FlingerModuleScreen;
import me.desht.modularrouters.client.gui.module.FluidModuleScreen;
import me.desht.modularrouters.client.gui.module.ModuleScreen;
import me.desht.modularrouters.client.gui.module.PlayerModuleScreen;
import me.desht.modularrouters.client.gui.module.VacuumModuleScreen;
import me.desht.modularrouters.client.model.ModelBakeEventHandler;
import me.desht.modularrouters.client.render.area.ModuleTargetRenderer;
import me.desht.modularrouters.client.render.blockentity.ModularRouterBER;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.logic.compiled.CompiledDistributorModule;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="modularrouters", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static KeyMapping keybindConfigure;
    public static KeyMapping keybindModuleInfo;

    public static void initEarly(IEventBus modBus) {
        modBus.register(ModelBakeEventHandler.class);
        NeoForge.EVENT_BUS.register(ModuleTargetRenderer.class);
        NeoForge.EVENT_BUS.register(MouseOverHelp.class);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ClientSetup.registerItemModelOverrides());
        FilterScreenFactory.registerGuiHandler((Item)ModItems.INSPECTION_FILTER.get(), InspectionFilterScreen::new);
        FilterScreenFactory.registerGuiHandler((Item)ModItems.REGEX_FILTER.get(), RegexFilterScreen::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntities.MODULAR_ROUTER.get(), ModularRouterBER::new);
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        keybindConfigure = new KeyMapping("key.modularrouters.configure", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.getKey((int)67, (int)-1), "key.modularrouters.category");
        keybindModuleInfo = new KeyMapping("key.modularrouters.moduleInfo", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.getKey((int)73, (int)-1), "key.modularrouters.category");
        event.register(keybindConfigure);
        event.register(keybindModuleInfo);
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.ROUTER_MENU.get(), ModularRouterScreen::new);
        event.register(ModMenuTypes.BASE_MODULE_MENU.get(), ModuleScreen::new);
        event.register(ModMenuTypes.ACTIVATOR_MENU.get(), ActivatorModuleScreen::new);
        event.register(ModMenuTypes.BREAKER_MENU.get(), BreakerModuleScreen::new);
        event.register(ModMenuTypes.DETECTOR_MENU.get(), DetectorModuleScreen::new);
        event.register(ModMenuTypes.DISTRIBUTOR_MENU.get(), DistributorModuleScreen::new);
        event.register(ModMenuTypes.EXTRUDER2_MENU.get(), ExtruderModule2Screen::new);
        event.register(ModMenuTypes.FLINGER_MENU.get(), FlingerModuleScreen::new);
        event.register(ModMenuTypes.FLUID_MENU.get(), FluidModuleScreen::new);
        event.register(ModMenuTypes.PLAYER_MENU.get(), PlayerModuleScreen::new);
        event.register(ModMenuTypes.VACUUM_MENU.get(), VacuumModuleScreen::new);
        event.register(ModMenuTypes.BULK_FILTER_MENU.get(), BulkItemFilterScreen::new);
        event.register(ModMenuTypes.MOD_FILTER_MENU.get(), ModFilterScreen::new);
        event.register(ModMenuTypes.TAG_FILTER_MENU.get(), TagFilterScreen::new);
    }

    private static void registerItemModelOverrides() {
        ItemProperties.register((Item)((Item)ModItems.DISTRIBUTOR_MODULE.get()), (ResourceLocation)MiscUtil.RL("mode"), (stack, world, entity, n) -> {
            if (entity != null) {
                return ((CompiledDistributorModule.DistributorSettings)stack.getOrDefault(ModDataComponents.DISTRIBUTOR_SETTINGS, (Object)CompiledDistributorModule.DistributorSettings.DEFAULT)).isPulling() ? 1.0f : 0.0f;
            }
            return 0.0f;
        });
    }
}

