/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.net;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.function.IntFunction;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class FramedByteBufCodecs {
    public static <B extends ByteBuf, V> StreamCodec<B, V[]> array(final StreamCodec<? super B, V> wrapped, final IntFunction<V[]> arrayFactory, final int maxSize) {
        return new StreamCodec<B, V[]>(){

            public void encode(B buf, V[] arr) {
                ByteBufCodecs.writeCount(buf, (int)arr.length, (int)maxSize);
                for (Object v : arr) {
                    wrapped.encode(buf, v);
                }
            }

            public V[] decode(B buf) {
                int size = ByteBufCodecs.readCount(buf, (int)maxSize);
                Object[] arr = (Object[])arrayFactory.apply(size);
                for (int i = 0; i < size; ++i) {
                    arr[i] = wrapped.decode(buf);
                }
                return arr;
            }
        };
    }

    public static <B extends ByteBuf, C extends LongCollection> StreamCodec<B, C> longCollection(IntFunction<C> collectionFactory) {
        return FramedByteBufCodecs.longCollection(collectionFactory, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, C extends LongCollection> StreamCodec<B, C> longCollection(final IntFunction<C> collectionFactory, final int maxSize) {
        return new StreamCodec<B, C>(){

            public C decode(B buf) {
                int size = ByteBufCodecs.readCount(buf, (int)maxSize);
                LongCollection collection = (LongCollection)collectionFactory.apply(size);
                for (int i = 0; i < size; ++i) {
                    collection.add(VarLong.read(buf));
                }
                return collection;
            }

            public void encode(B buf, C collection) {
                ByteBufCodecs.writeCount(buf, (int)collection.size(), (int)maxSize);
                collection.forEach(value -> VarLong.write((ByteBuf)buf, (long)value));
            }
        };
    }

    private FramedByteBufCodecs() {
    }
}

