/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import com.google.common.base.Preconditions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.FramedChestBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedStorageMenu
extends AbstractContainerMenu {
    private static final int MAX_SLOT_CHEST = 27;
    private final FramedStorageBlockEntity blockEntity;

    public FramedStorageMenu(int windowId, Inventory inv, BlockEntity blockEntity) {
        super((MenuType)FBContent.MENU_TYPE_FRAMED_STORAGE.value(), windowId);
        Preconditions.checkArgument((boolean)(blockEntity instanceof FramedStorageBlockEntity));
        this.blockEntity = (FramedStorageBlockEntity)blockEntity;
        IItemHandler blockInv = this.blockEntity.getItemHandler();
        if (this.blockEntity.getLevel().isClientSide()) {
            blockInv = new ItemStackHandler(blockInv.getSlots());
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot((Slot)new SlotItemHandler(blockInv, col + row * 9, 8 + col * 18, 18 + row * 18));
            }
        }
        FramedUtils.addPlayerInvSlots(x$0 -> this.addSlot((Slot)x$0), inv, 8, 85);
    }

    public FramedStorageMenu(int windowId, Inventory inv, FriendlyByteBuf extraData) {
        this(windowId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public boolean stillValid(Player player) {
        return this.blockEntity.isUsableByPlayer(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack remainder = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            remainder = stack.copy();
            if (index < 27 ? !this.moveItemStackTo(stack, 27, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return remainder;
    }

    public void removed(Player player) {
        FramedStorageBlockEntity framedStorageBlockEntity;
        super.removed(player);
        if (!this.blockEntity.getLevel().isClientSide() && (framedStorageBlockEntity = this.blockEntity) instanceof FramedChestBlockEntity) {
            FramedChestBlockEntity chest = (FramedChestBlockEntity)framedStorageBlockEntity;
            chest.close();
        }
    }
}

