/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public abstract class FramedSpecialDoubleBlockItem
extends BlockItem {
    public FramedSpecialDoubleBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        BlockState newState;
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState originalState = level.getBlockState(pos);
        if (ctx.canPlace() && originalState.is(this.getBlock()) && (newState = this.getReplacementState(ctx, originalState)) != null) {
            if (!level.isClientSide()) {
                boolean writeToCamoTwo = this.shouldWriteToCamoTwo(ctx, originalState);
                Utils.wrapInStateCopy((LevelAccessor)level, pos, ctx.getPlayer(), ctx.getItemInHand(), writeToCamoTwo, true, () -> level.setBlockAndUpdate(pos, newState));
                SoundType sound = ((Block)FBContent.BLOCK_FRAMED_CUBE.value()).defaultBlockState().getSoundType();
                level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.place(ctx);
    }

    @Nullable
    protected abstract BlockState getReplacementState(BlockPlaceContext var1, BlockState var2);

    protected abstract boolean shouldWriteToCamoTwo(BlockPlaceContext var1, BlockState var2);
}

