/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.item;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.BlueprintCopyBehaviour;
import xfacthd.framedblocks.api.blueprint.BlueprintData;
import xfacthd.framedblocks.api.blueprint.RegisterBlueprintCopyBehavioursEvent;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.config.ServerConfig;
import xfacthd.framedblocks.common.data.FramedToolType;
import xfacthd.framedblocks.common.item.FramedToolItem;

public class FramedBlueprintItem
extends FramedToolItem {
    public static final String CONTAINED_BLOCK = "desc.framedblocks.blueprint_block";
    public static final String CAMO_BLOCK = "desc.framedblocks.blueprint_camo";
    public static final String IS_ILLUMINATED = "desc.framedblocks.blueprint_illuminated";
    public static final String IS_INTANGIBLE = "desc.framedblocks.blueprint_intangible";
    public static final String IS_REINFORCED = "desc.framedblocks.blueprint_reinforced";
    public static final String MISSING_MATERIALS = Utils.translationKey("desc", "blueprint_missing_materials");
    public static final MutableComponent BLOCK_NONE = Utils.translate("desc", "blueprint_none").withStyle(ChatFormatting.RED);
    public static final MutableComponent BLOCK_INVALID = Utils.translate("desc", "blueprint_invalid").withStyle(ChatFormatting.RED);
    public static final MutableComponent FALSE = Utils.translate("desc", "blueprint_false").withStyle(ChatFormatting.RED);
    public static final MutableComponent TRUE = Utils.translate("desc", "blueprint_true").withStyle(ChatFormatting.GREEN);
    public static final MutableComponent CANT_COPY = Utils.translate("desc", "blueprint_cant_copy").withStyle(ChatFormatting.RED);
    public static final Component CANT_PLACE_FLUID_CAMO = Utils.translate("desc", "blueprint_cant_place_fluid_camo").withStyle(ChatFormatting.RED);
    private static final String MATERIAL_LIST_PREFIX = "\n  - ";
    private static final Map<Block, BlueprintCopyBehaviour> COPY_BEHAVIOURS = new IdentityHashMap<Block, BlueprintCopyBehaviour>();
    private static final BlueprintCopyBehaviour NO_OP_BEHAVIOUR = new BlueprintCopyBehaviour(){};

    public FramedBlueprintItem(FramedToolType type) {
        super(type, new Item.Properties().component(FBContent.DC_TYPE_BLUEPRINT_DATA, (Object)BlueprintData.EMPTY));
    }

    @Override
    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                stack.set(FBContent.DC_TYPE_BLUEPRINT_DATA, (Object)BlueprintData.EMPTY);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return super.use(level, player, hand);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (player.isShiftKeyDown()) {
            return FramedBlueprintItem.writeBlueprint(level, pos, context.getItemInHand());
        }
        BlueprintData data = (BlueprintData)context.getItemInHand().getOrDefault(FBContent.DC_TYPE_BLUEPRINT_DATA, (Object)BlueprintData.EMPTY);
        if (!data.isEmpty()) {
            return FramedBlueprintItem.readBlueprint(context, player, data);
        }
        return super.useOn(context);
    }

    private static InteractionResult writeBlueprint(Level level, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FramedBlockEntity)) {
            return InteractionResult.FAIL;
        }
        FramedBlockEntity be = (FramedBlockEntity)blockEntity;
        if (!level.isClientSide()) {
            BlockState state = be.getBlockState();
            BlueprintData data = FramedBlueprintItem.getBehaviour(state.getBlock()).writeToBlueprint(level, pos, state, be);
            stack.set(FBContent.DC_TYPE_BLUEPRINT_DATA, (Object)data);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private static InteractionResult readBlueprint(UseOnContext context, Player player, BlueprintData data) {
        Block block = data.block();
        if (block.defaultBlockState().isAir()) {
            return InteractionResult.FAIL;
        }
        Item item = block.asItem();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.FAIL;
        }
        BlockItem blockItem = (BlockItem)item;
        if (FramedBlueprintItem.checkMissingMaterials(player, data)) {
            return InteractionResult.FAIL;
        }
        return FramedBlueprintItem.tryPlace(context, player, blockItem, data);
    }

    private static boolean checkMissingMaterials(Player player, BlueprintData data) {
        int reinforcement;
        int intangible;
        BlueprintCopyBehaviour behaviour;
        int glowstone;
        if (player.getAbilities().instabuild) {
            return false;
        }
        CamoList camos = FramedBlueprintItem.getCamoContainers(data);
        if (!FramedBlueprintItem.canCopyAllCamos(camos)) {
            if (player.level().isClientSide()) {
                player.sendSystemMessage(CANT_PLACE_FLUID_CAMO);
            }
            return true;
        }
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        materials.add(FramedBlueprintItem.getBlockItem(data));
        if (ServerConfig.VIEW.shouldConsumeCamoItem()) {
            materials.addAll(FramedBlueprintItem.getCamoStacksMerged(camos));
        }
        if ((glowstone = (behaviour = FramedBlueprintItem.getBehaviour(data.block())).getGlowstoneCount(data)) > 0) {
            materials.add(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, glowstone));
        }
        if ((intangible = behaviour.getIntangibleCount(data)) > 0) {
            materials.add(new ItemStack((ItemLike)ServerConfig.VIEW.getIntangibilityMarkerItem(), glowstone));
        }
        if ((reinforcement = behaviour.getReinforcementCount(data)) > 0) {
            materials.add(new ItemStack((ItemLike)FBContent.ITEM_FRAMED_REINFORCEMENT.value(), reinforcement));
        }
        materials.addAll(behaviour.getAdditionalConsumedMaterials(data));
        ArrayList<ItemStack> missingMaterials = new ArrayList<ItemStack>();
        for (ItemStack stack : materials) {
            if (stack.isEmpty() || player.getInventory().countItem(stack.getItem()) >= stack.getCount()) continue;
            missingMaterials.add(stack);
        }
        if (!missingMaterials.isEmpty()) {
            if (player.level().isClientSide()) {
                List<String> names = missingMaterials.stream().map(s -> s.getHoverName().getString()).toList();
                String list = MATERIAL_LIST_PREFIX + String.join((CharSequence)MATERIAL_LIST_PREFIX, names);
                player.sendSystemMessage((Component)Component.translatable((String)MISSING_MATERIALS).append(list));
            }
            return true;
        }
        return false;
    }

    private static InteractionResult tryPlace(UseOnContext context, Player player, BlockItem item, BlueprintData data) {
        ItemStack dummyStack = new ItemStack((ItemLike)item, 1);
        UseOnContext placeContext = new UseOnContext(context.getLevel(), context.getPlayer(), context.getHand(), dummyStack, new BlockHitResult(context.getClickLocation(), context.getClickedFace(), context.getClickedPos(), context.isInside()));
        BlockPos pos = new BlockPlaceContext(placeContext).getClickedPos();
        InteractionResult result = item.useOn(placeContext);
        if (!context.getLevel().isClientSide() && result.consumesAction()) {
            BlockEntity blockEntity = context.getLevel().getBlockEntity(pos);
            if (blockEntity instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                be.applyBlueprintData(data);
            }
            FramedBlueprintItem.getBehaviour(data.block()).postProcessPaste(context.getLevel(), pos, context.getPlayer(), data, dummyStack);
            if (!player.getAbilities().instabuild) {
                FramedBlueprintItem.consumeItems(player, data);
            }
        }
        return result;
    }

    private static void consumeItems(Player player, BlueprintData data) {
        int reinforcement;
        int intangible;
        BlueprintCopyBehaviour behaviour;
        int glowstone;
        CamoList camos = FramedBlueprintItem.getCamoContainers(data);
        if (!FramedBlueprintItem.canCopyAllCamos(camos)) {
            return;
        }
        ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
        materials.add(FramedBlueprintItem.getBlockItem(data));
        if (ServerConfig.VIEW.shouldConsumeCamoItem()) {
            materials.addAll(FramedBlueprintItem.getCamoStacksMerged(camos));
        }
        if ((glowstone = (behaviour = FramedBlueprintItem.getBehaviour(data.block())).getGlowstoneCount(data)) > 0) {
            materials.add(new ItemStack((ItemLike)Items.GLOWSTONE_DUST, glowstone));
        }
        if ((intangible = behaviour.getIntangibleCount(data)) > 0) {
            materials.add(new ItemStack((ItemLike)ServerConfig.VIEW.getIntangibilityMarkerItem(), glowstone));
        }
        if ((reinforcement = behaviour.getReinforcementCount(data)) > 0) {
            materials.add(new ItemStack((ItemLike)FBContent.ITEM_FRAMED_REINFORCEMENT.value(), reinforcement));
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            for (ItemStack material : materials) {
                if (material.isEmpty() || !stack.is(material.getItem())) continue;
                int size = stack.getCount();
                stack.shrink(Math.min(material.getCount(), size));
                material.shrink(size - stack.getCount());
                inv.setChanged();
            }
            materials.removeIf(ItemStack::isEmpty);
            if (materials.isEmpty()) break;
        }
    }

    private static boolean canCopyAllCamos(CamoList camos) {
        if (!ServerConfig.VIEW.shouldConsumeCamoItem()) {
            return true;
        }
        return camos.stream().map(CamoContainer::getFactory).allMatch(CamoContainerFactory::canTriviallyConvertToItemStack);
    }

    public static BlueprintCopyBehaviour getBehaviour(Block block) {
        return COPY_BEHAVIOURS.getOrDefault(block, NO_OP_BEHAVIOUR);
    }

    public static CamoList getCamoContainers(BlueprintData data) {
        return FramedBlueprintItem.getBehaviour(data.block()).getCamos(data);
    }

    private static ItemStack getBlockItem(BlueprintData data) {
        return FramedBlueprintItem.getBehaviour(data.block()).getBlockItem(data);
    }

    private static List<ItemStack> getCamoStacksMerged(CamoList camos) {
        ArrayList<ItemStack> camoStacks = new ArrayList<ItemStack>();
        for (CamoContainer<?, ?> camo : camos) {
            ItemStack stack = CamoContainerHelper.dropCamo(camo);
            if (stack.isEmpty()) continue;
            for (ItemStack existing : camoStacks) {
                if (!ItemStack.isSameItem((ItemStack)existing, (ItemStack)stack)) continue;
                int size = existing.getCount();
                existing.grow(Math.min(existing.getMaxStackSize() - size, stack.getCount()));
                stack.shrink(existing.getCount() - size);
                if (!stack.isEmpty()) continue;
                break;
            }
            if (stack.isEmpty()) continue;
            camoStacks.add(stack);
        }
        return camoStacks;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> components, TooltipFlag flag) {
        BlueprintData blueprintData = (BlueprintData)stack.getOrDefault(FBContent.DC_TYPE_BLUEPRINT_DATA, (Object)BlueprintData.EMPTY);
        if (blueprintData.isEmpty()) {
            components.add((Component)Component.translatable((String)CONTAINED_BLOCK, (Object[])new Object[]{BLOCK_NONE}).withStyle(ChatFormatting.GOLD));
        } else {
            MutableComponent mutableComponent;
            MutableComponent blockName;
            Block block = blueprintData.block();
            MutableComponent mutableComponent2 = blockName = block == Blocks.AIR ? BLOCK_INVALID : block.getName().withStyle(ChatFormatting.WHITE);
            if (!(block instanceof IFramedBlock)) {
                mutableComponent = BLOCK_NONE;
            } else {
                IFramedBlock fb = (IFramedBlock)block;
                mutableComponent = (Component)fb.printCamoBlock(blueprintData).orElse(BLOCK_NONE);
            }
            MutableComponent camoName = mutableComponent;
            MutableComponent illuminated = blueprintData.glowing() ? TRUE : FALSE;
            MutableComponent intangible = blueprintData.intangible() ? TRUE : FALSE;
            MutableComponent reinforced = blueprintData.reinforced() ? TRUE : FALSE;
            MutableComponent lineOne = Component.translatable((String)CONTAINED_BLOCK, (Object[])new Object[]{blockName}).withStyle(ChatFormatting.GOLD);
            MutableComponent lineTwo = Component.translatable((String)CAMO_BLOCK, (Object[])new Object[]{camoName}).withStyle(ChatFormatting.GOLD);
            MutableComponent lineThree = Component.translatable((String)IS_ILLUMINATED, (Object[])new Object[]{illuminated}).withStyle(ChatFormatting.GOLD);
            MutableComponent lineFour = Component.translatable((String)IS_INTANGIBLE, (Object[])new Object[]{intangible}).withStyle(ChatFormatting.GOLD);
            MutableComponent lineFive = Component.translatable((String)IS_REINFORCED, (Object[])new Object[]{reinforced}).withStyle(ChatFormatting.GOLD);
            components.addAll(Arrays.asList(lineOne, lineTwo, lineThree, lineFour, lineFive));
        }
    }

    public static void init() {
        ModLoader.postEvent((Event)new RegisterBlueprintCopyBehavioursEvent((behaviour, blocks) -> {
            Preconditions.checkNotNull((Object)behaviour, (Object)"BlueprintCopyBehaviour must be non-null");
            Preconditions.checkState((((Block[])blocks).length > 0 ? 1 : 0) != 0, (Object)"At least one block must be provided to register a BlueprintCopyBehaviour");
            for (Block block : blocks) {
                Preconditions.checkNotNull((Object)block);
                COPY_BEHAVIOURS.put(block, (BlueprintCopyBehaviour)behaviour);
            }
        }));
    }
}

