/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import xfacthd.framedblocks.common.FBContent;

public final class FramedLootTableProvider
extends LootTableProvider {
    public FramedLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> providerFuture) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTable::new, LootContextParamSets.BLOCK)), providerFuture);
    }

    private static class BlockLootTable
    extends BlockLootSubProvider {
        public BlockLootTable(HolderLookup.Provider lookupProvider) {
            super(Set.of(), FeatureFlags.VANILLA_SET, lookupProvider);
        }

        protected Iterable<Block> getKnownBlocks() {
            return FBContent.getRegisteredBlocks().stream().map(Holder::value).collect(Collectors.toList());
        }

        protected void generate() {
            this.dropOther((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_PRESSURE_PLATE.value(), (ItemLike)FBContent.BLOCK_FRAMED_PRESSURE_PLATE.value());
            this.dropOther((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE.value(), (ItemLike)FBContent.BLOCK_FRAMED_STONE_PRESSURE_PLATE.value());
            this.dropOther((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE.value(), (ItemLike)FBContent.BLOCK_FRAMED_OBSIDIAN_PRESSURE_PLATE.value());
            this.dropOther((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE.value(), (ItemLike)FBContent.BLOCK_FRAMED_GOLD_PRESSURE_PLATE.value());
            this.dropOther((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE.value(), (ItemLike)FBContent.BLOCK_FRAMED_IRON_PRESSURE_PLATE.value());
            this.dropDoor((Block)FBContent.BLOCK_FRAMED_DOOR.value());
            this.dropDoor((Block)FBContent.BLOCK_FRAMED_IRON_DOOR.value());
            this.dropTwoOf((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLAB.value(), (Block)FBContent.BLOCK_FRAMED_SLAB.value());
            this.dropTwoOf((Block)FBContent.BLOCK_FRAMED_DOUBLE_PANEL.value(), (Block)FBContent.BLOCK_FRAMED_PANEL.value());
            this.dropOther((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE.value(), (ItemLike)FBContent.BLOCK_FRAMED_HALF_SLOPE.value());
            this.dropOther((Block)FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_SLOPE.value(), (ItemLike)FBContent.BLOCK_FRAMED_DOUBLE_HALF_SLOPE.value());
            this.add((Block)FBContent.BLOCK_FRAMED_MASONRY_CORNER_SEGMENT.value(), BlockLootTable.noDrop());
            this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_CUBE_SEGMENT.value(), BlockLootTable.noDrop());
            this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_SLAB_SEGMENT.value(), BlockLootTable.noDrop());
            this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_PANEL_SEGMENT.value(), BlockLootTable.noDrop());
            FBContent.getRegisteredBlocks().stream().map(Holder::value).filter(block -> !this.map.containsKey(block.getLootTable())).forEach(x$0 -> this.dropSelf((Block)x$0));
        }

        protected void dropTwoOf(Block block, Block drop) {
            this.add(block, b -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)drop).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))))));
        }

        protected void dropDoor(Block block) {
            this.add(block, x$0 -> this.createDoorTable((Block)x$0));
        }
    }
}

