/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public final class FramedBlockTagProvider
extends BlockTagsProvider {
    public FramedBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper fileHelper) {
        super(output, lookupProvider, "framedblocks", fileHelper);
    }

    public String getName() {
        return super.getName() + ": framedblocks";
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(BlockTags.SLABS).add((Object)((Block)FBContent.BLOCK_FRAMED_SLAB.value()));
        this.tag(BlockTags.STAIRS).add((Object)((Block)FBContent.BLOCK_FRAMED_STAIRS.value()));
        this.tag(BlockTags.WALLS).add((Object)((Block)FBContent.BLOCK_FRAMED_WALL.value()));
        this.tag(BlockTags.FENCES).add((Object)((Block)FBContent.BLOCK_FRAMED_FENCE.value()));
        this.tag(BlockTags.DOORS).add((Object[])new Block[]{(Block)FBContent.BLOCK_FRAMED_DOOR.value(), (Block)FBContent.BLOCK_FRAMED_IRON_DOOR.value()});
        this.tag(BlockTags.TRAPDOORS).add((Object[])new Block[]{(Block)FBContent.BLOCK_FRAMED_TRAP_DOOR.value(), (Block)FBContent.BLOCK_FRAMED_IRON_TRAP_DOOR.value()});
        this.tag(BlockTags.CLIMBABLE).add((Object)((Block)FBContent.BLOCK_FRAMED_LADDER.value()));
        this.tag(BlockTags.SIGNS).add((Object[])new Block[]{(Block)FBContent.BLOCK_FRAMED_SIGN.value(), (Block)FBContent.BLOCK_FRAMED_WALL_SIGN.value()});
        this.tag(BlockTags.STANDING_SIGNS).add((Object)((Block)FBContent.BLOCK_FRAMED_SIGN.value()));
        this.tag(BlockTags.WALL_SIGNS).add((Object)((Block)FBContent.BLOCK_FRAMED_WALL_SIGN.value()));
        this.tag(BlockTags.CEILING_HANGING_SIGNS).add((Object)((Block)FBContent.BLOCK_FRAMED_HANGING_SIGN.value()));
        this.tag(BlockTags.WALL_HANGING_SIGNS).add((Object)((Block)FBContent.BLOCK_FRAMED_WALL_HANGING_SIGN.value()));
        this.tag(Tags.Blocks.CHESTS).add((Object)((Block)FBContent.BLOCK_FRAMED_CHEST.value()));
        this.tag(BlockTags.RAILS).add((Object[])new Block[]{(Block)FBContent.BLOCK_FRAMED_RAIL_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_POWERED_RAIL_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_DETECTOR_RAIL_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_ACTIVATOR_RAIL_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_RAIL.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_RAIL_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL_SLOPE.value(), (Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE.value()});
        this.tag(BlockTags.ENCHANTMENT_POWER_PROVIDER).add((Object)((Block)FBContent.BLOCK_FRAMED_BOOKSHELF.value()));
        this.tag(Tags.Blocks.BOOKSHELVES).add((Object)((Block)FBContent.BLOCK_FRAMED_BOOKSHELF.value()));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender frameable = this.tag(Utils.FRAMEABLE).addTags(new TagKey[]{Tags.Blocks.GLASS_BLOCKS, BlockTags.ICE, BlockTags.LEAVES});
        frameable.addOptional(Utils.rl("create", "oak_window")).addOptional(Utils.rl("create", "spruce_window")).addOptional(Utils.rl("create", "birch_window")).addOptional(Utils.rl("create", "jungle_window")).addOptional(Utils.rl("create", "acacia_window")).addOptional(Utils.rl("create", "dark_oak_window")).addOptional(Utils.rl("create", "crimson_window")).addOptional(Utils.rl("create", "warped_window")).addOptional(Utils.rl("create", "ornate_iron_window")).addOptionalTag(Utils.rl("chipped", "glass")).addOptionalTag(Utils.rl("chipped", "white_stained_glass")).addOptionalTag(Utils.rl("chipped", "orange_stained_glass")).addOptionalTag(Utils.rl("chipped", "magenta_stained_glass")).addOptionalTag(Utils.rl("chipped", "light_blue_stained_glass")).addOptionalTag(Utils.rl("chipped", "yellow_stained_glass")).addOptionalTag(Utils.rl("chipped", "lime_stained_glass")).addOptionalTag(Utils.rl("chipped", "pink_stained_glass")).addOptionalTag(Utils.rl("chipped", "gray_stained_glass")).addOptionalTag(Utils.rl("chipped", "light_gray_stained_glass")).addOptionalTag(Utils.rl("chipped", "cyan_stained_glass")).addOptionalTag(Utils.rl("chipped", "purple_stained_glass")).addOptionalTag(Utils.rl("chipped", "blue_stained_glass")).addOptionalTag(Utils.rl("chipped", "brown_stained_glass")).addOptionalTag(Utils.rl("chipped", "green_stained_glass")).addOptionalTag(Utils.rl("chipped", "red_stained_glass")).addOptionalTag(Utils.rl("chipped", "black_stained_glass")).addOptionalTag(Utils.rl("forge", "hardened_glass"));
        this.tag(Utils.BLOCK_BLACKLIST).add((Object[])new Block[]{Blocks.PISTON, Blocks.STICKY_PISTON, Blocks.COMPOSTER});
        this.tag(Utils.BE_WHITELIST);
        Set<Block> noToolBlocks = Set.of((Block)FBContent.BLOCK_FRAMED_ITEM_FRAME.value(), (Block)FBContent.BLOCK_FRAMED_GLOWING_ITEM_FRAME.value());
        LinkedHashSet<Block> pickaxeBlocks = new LinkedHashSet<Block>();
        pickaxeBlocks.add((Block)FBContent.BLOCK_FRAMED_IRON_DOOR.value());
        pickaxeBlocks.add((Block)FBContent.BLOCK_FRAMED_IRON_TRAP_DOOR.value());
        pickaxeBlocks.add((Block)FBContent.BLOCK_FRAMED_IRON_GATE.value());
        pickaxeBlocks.add((Block)FBContent.BLOCK_FRAMING_SAW.value());
        pickaxeBlocks.add((Block)FBContent.BLOCK_POWERED_FRAMING_SAW.value());
        IntrinsicHolderTagsProvider.IntrinsicTagAppender axeTag = this.tag(BlockTags.MINEABLE_WITH_AXE);
        FBContent.getRegisteredBlocks().stream().map(Holder::value).filter(b -> b instanceof IFramedBlock).filter(b -> !noToolBlocks.contains(b)).filter(b -> !pickaxeBlocks.contains(b)).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)axeTag).add(arg_0));
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])((Block[])pickaxeBlocks.toArray(Block[]::new)));
        this.tag(BlockTags.create((ResourceLocation)Utils.rl("diagonalwindows", "non_diagonal_panes"))).add((Object)((Block)FBContent.BLOCK_FRAMED_BARS.value()));
    }
}

