/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_LATTICE_BLOCK})
public final class LatticeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            boolean xAxis = (Boolean)state.getValue((Property)FramedProperties.X_AXIS);
            boolean yAxis = (Boolean)state.getValue((Property)FramedProperties.Y_AXIS);
            boolean zAxis = (Boolean)state.getValue((Property)FramedProperties.Z_AXIS);
            return switch (type) {
                case BlockType.FRAMED_LATTICE_BLOCK -> LatticeSkipPredicate.testAgainstLattice(xAxis, yAxis, zAxis, adjState, side);
                case BlockType.FRAMED_FENCE -> LatticeSkipPredicate.testAgainstWall(yAxis, side);
                case BlockType.FRAMED_POST -> LatticeSkipPredicate.testAgainstPost(xAxis, yAxis, zAxis, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LATTICE_BLOCK})
    private static boolean testAgainstLattice(boolean xAxis, boolean yAxis, boolean zAxis, BlockState adjState, Direction side) {
        return switch (side.getAxis()) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> {
                if (xAxis && ((Boolean)adjState.getValue((Property)FramedProperties.X_AXIS)).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Y -> {
                if (yAxis && ((Boolean)adjState.getValue((Property)FramedProperties.Y_AXIS)).booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> zAxis && (Boolean)adjState.getValue((Property)FramedProperties.Z_AXIS) != false;
        };
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FENCE})
    private static boolean testAgainstWall(boolean yAxis, Direction side) {
        return yAxis && Utils.isY(side);
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_POST})
    private static boolean testAgainstPost(boolean xAxis, boolean yAxis, boolean zAxis, BlockState adjState, Direction side) {
        boolean bl;
        block8: {
            block7: {
                Direction.Axis adjAxis = (Direction.Axis)adjState.getValue((Property)BlockStateProperties.AXIS);
                if (adjAxis != side.getAxis()) break block7;
                switch (adjAxis) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        if (xAxis) {
                            break;
                        }
                        break block7;
                    }
                    case Y: {
                        if (yAxis) {
                            break;
                        }
                        break block7;
                    }
                    case Z: {
                        if (!zAxis) break block7;
                    }
                }
                bl = true;
                break block8;
            }
            bl = false;
        }
        return bl;
    }
}

