/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.appearance;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.config.ClientConfig;

public final class AppearanceHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();

    public static BlockState getAppearance(IFramedBlock framedBlock, BlockState state, BlockGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return AppearanceHelper.getAppearance(framedBlock, state, level, pos, side, queryState, queryPos, false);
    }

    private static BlockState getAppearance(IFramedBlock framedBlock, BlockState state, BlockGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos, boolean recursive) {
        Direction conEdge;
        IBlockType type = framedBlock.getBlockType();
        if (!FMLEnvironment.dist.isClient() || !type.supportsConnectedTextures()) {
            return AIR;
        }
        ConTexMode cfgMode = ClientConfig.VIEW.getConTexMode();
        if (cfgMode == ConTexMode.NONE || queryPos == null) {
            return AIR;
        }
        BlockState actualQueryState = AppearanceHelper.findApplicableNeighbor(level, queryPos, queryState);
        if (actualQueryState == AIR) {
            return AIR;
        }
        Direction edge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, $ -> true);
        StateCache stateCache = framedBlock.getCache(state);
        if (type.isDoubleBlock()) {
            if (recursive) {
                LOGGER.error("AppearanceHelper#getAppearance() trying to recurse multiple times, this is a bug. Please report this to FramedBlocks with the following stacktrace. Pos: {}, State: {}, Side: {}", new Object[]{pos, state, side, new Throwable()});
                return AIR;
            }
            if (actualQueryState != null) {
                if (AppearanceHelper.isNotFramedOrCanConnectFullEdgeTo(pos, queryPos, actualQueryState, side, edge)) {
                    if (!stateCache.canConnectFullEdge(side, edge)) {
                        return AIR;
                    }
                    BlockState componentState = framedBlock.getComponentAtEdge(level, pos, state, side, edge);
                    if (componentState == null) {
                        return AIR;
                    }
                    FramedBlockData modelData = AppearanceHelper.getModelData(level, pos, componentState, false);
                    return modelData != null ? modelData.getCamoContent().getAppearanceState() : AIR;
                }
                if (edge == null) {
                    return AIR;
                }
                BlockState componentState = framedBlock.getComponentBySkipPredicate(level, pos, state, actualQueryState, edge);
                if (componentState != null) {
                    IFramedBlock componentBlock = (IFramedBlock)componentState.getBlock();
                    return AppearanceHelper.getAppearance(componentBlock, componentState, level, pos, side, actualQueryState, queryPos, true);
                }
            }
            return AIR;
        }
        FramedBlockData modelData = AppearanceHelper.getModelData(level, pos, state, true);
        if (modelData == null) {
            return AIR;
        }
        ConTexMode typeMode = type.getMinimumConTexMode();
        if (AppearanceHelper.canUseMode(cfgMode, typeMode, ConTexMode.FULL_FACE) && stateCache.canConnectFullEdge(side, null)) {
            if (AppearanceHelper.isNotFramedOrCanConnectFullEdgeTo(pos, queryPos, actualQueryState, side, edge)) {
                return modelData.getCamoContent().getAppearanceState();
            }
            return AIR;
        }
        if (edge == null) {
            return AIR;
        }
        if (AppearanceHelper.canUseMode(cfgMode, typeMode, ConTexMode.FULL_EDGE) && (conEdge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, testEdge -> stateCache.canConnectFullEdge(side, (Direction)testEdge))) != null) {
            return modelData.getCamoContent().getAppearanceState();
        }
        if (cfgMode == ConTexMode.DETAILED && !queryPos.equals((Object)pos)) {
            Direction detEdge = AppearanceHelper.findFirstSuitableDirectionFromOffset(pos, queryPos, side, modelData::isSideHidden);
            if (detEdge != null && stateCache.canConnectDetailed(side, detEdge)) {
                return modelData.getCamoContent().getAppearanceState();
            }
        }
        return AIR;
    }

    private static boolean canUseMode(ConTexMode cfgMode, ConTexMode typeMode, ConTexMode targetMode) {
        return cfgMode.atleast(targetMode) && targetMode.atleast(typeMode);
    }

    private static Direction findFirstSuitableDirectionFromOffset(BlockPos pos, BlockPos queryPos, Direction side, Predicate<Direction> pred) {
        int nz;
        int ny;
        if (pos.equals((Object)queryPos)) {
            return null;
        }
        int nx = queryPos.getX() - pos.getX();
        Direction conFace = Utils.dirByNormal(nx, ny = queryPos.getY() - pos.getY(), nz = queryPos.getZ() - pos.getZ());
        if (conFace != null) {
            return pred.test(conFace) ? conFace : null;
        }
        if (!Utils.isX(side) && (conFace = Utils.dirByNormal(nx, 0, 0)) != null && pred.test(conFace)) {
            return conFace;
        }
        if (!Utils.isY(side) && (conFace = Utils.dirByNormal(0, ny, 0)) != null && pred.test(conFace)) {
            return conFace;
        }
        if (!Utils.isZ(side) && (conFace = Utils.dirByNormal(0, 0, nz)) != null && pred.test(conFace)) {
            return conFace;
        }
        return null;
    }

    private static BlockState findApplicableNeighbor(BlockGetter level, BlockPos queryPos, @Nullable BlockState queryState) {
        Block block;
        if (queryState == null) {
            queryState = level.getBlockState(queryPos);
        }
        if ((block = queryState.getBlock()) instanceof IFramedBlock) {
            IFramedBlock queryBlock = (IFramedBlock)block;
            IBlockType type = queryBlock.getBlockType();
            if (type.isDoubleBlock()) {
                return null;
            }
            return type.supportsConnectedTextures() ? queryState : AIR;
        }
        return queryState.isAir() ? AIR : queryState;
    }

    private static boolean isNotFramedOrCanConnectFullEdgeTo(BlockPos pos, BlockPos queryPos, BlockState queryState, Direction side, @Nullable Direction edge) {
        Block block;
        if (queryState != null && (block = queryState.getBlock()) instanceof IFramedBlock) {
            IFramedBlock queryBlock = (IFramedBlock)block;
            int nx = queryPos.getX() - pos.getX();
            int ny = queryPos.getY() - pos.getY();
            int nz = queryPos.getZ() - pos.getZ();
            if (side.getAxis().choose(nx, ny, nz) != 0) {
                side = side.getOpposite();
            }
            if (edge != null) {
                edge = edge.getOpposite();
            }
            return queryBlock.getCache(queryState).canConnectFullEdge(side, edge);
        }
        return true;
    }

    private static FramedBlockData getModelData(BlockGetter level, BlockPos pos, BlockState componentState, boolean mayBeSingle) {
        FramedBlockData fbData;
        ModelData data = level.getModelData(pos);
        if (data == ModelData.EMPTY) {
            return null;
        }
        if (mayBeSingle && (fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY)) != null) {
            return fbData;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof IFramedBlock) {
            IFramedBlock block2 = (IFramedBlock)block;
            return (FramedBlockData)block2.unpackNestedModelData(data, state, componentState).get(FramedBlockData.PROPERTY);
        }
        return null;
    }

    private AppearanceHelper() {
    }
}

