/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.predicate.fullface.FullFacePredicate;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ReloadableShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.block.cube.FramedTubeBlock;
import xfacthd.framedblocks.common.block.door.FramedGateBlock;
import xfacthd.framedblocks.common.block.interactive.FramedItemFrameBlock;
import xfacthd.framedblocks.common.block.pane.FramedCornerStripBlock;
import xfacthd.framedblocks.common.block.pane.FramedFloorBlock;
import xfacthd.framedblocks.common.block.pane.FramedWallBoardBlock;
import xfacthd.framedblocks.common.block.pillar.FramedCornerPillarBlock;
import xfacthd.framedblocks.common.block.pillar.FramedHalfPillarBlock;
import xfacthd.framedblocks.common.block.pillar.FramedLatticeBlock;
import xfacthd.framedblocks.common.block.pillar.FramedPillarBlock;
import xfacthd.framedblocks.common.block.pillar.FramedThreewayCornerPillarBlock;
import xfacthd.framedblocks.common.block.prism.FramedElevatedPrismBlock;
import xfacthd.framedblocks.common.block.prism.FramedElevatedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.prism.FramedPrismBlock;
import xfacthd.framedblocks.common.block.prism.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.sign.FramedCeilingHangingSignBlock;
import xfacthd.framedblocks.common.block.sign.FramedWallSignBlock;
import xfacthd.framedblocks.common.block.slab.FramedCenteredPanelBlock;
import xfacthd.framedblocks.common.block.slab.FramedCheckeredCubeSegmentBlock;
import xfacthd.framedblocks.common.block.slab.FramedCheckeredPanelSegmentBlock;
import xfacthd.framedblocks.common.block.slab.FramedCheckeredSlabSegmentBlock;
import xfacthd.framedblocks.common.block.slab.FramedMasonryCornerSegmentBlock;
import xfacthd.framedblocks.common.block.slab.FramedSlabCornerBlock;
import xfacthd.framedblocks.common.block.slab.FramedSlabEdgeBlock;
import xfacthd.framedblocks.common.block.slope.FramedCornerSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedDoubleHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedPrismCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedPyramidBlock;
import xfacthd.framedblocks.common.block.slope.FramedSlopeBlock;
import xfacthd.framedblocks.common.block.slope.FramedThreewayCornerBlock;
import xfacthd.framedblocks.common.block.slope.FramedVerticalHalfSlopeBlock;
import xfacthd.framedblocks.common.block.slopeedge.FramedElevatedSlopeEdgeBlock;
import xfacthd.framedblocks.common.block.slopeedge.FramedSlopeEdgeBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedExtendedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatExtendedSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatInverseDoubleSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedInverseDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedDoubleCornerSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedDoubleCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedExtendedCornerSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedExtendedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedInverseDoubleCornerSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedInverseDoubleCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatElevatedSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatInverseDoubleSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedFlatSlopeSlabCornerBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedInverseDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedDoubleHalfStairsBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedSlopedStairsBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalHalfStairsBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalSlopedStairsBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.conpreds.ConnectionPredicates;
import xfacthd.framedblocks.common.data.facepreds.FullFacePredicates;
import xfacthd.framedblocks.common.data.skippreds.SideSkipPredicates;

public enum BlockType implements IBlockType
{
    FRAMED_CUBE(true, false, false, false, true, true, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_SLOPE(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_HALF_SLOPE(false, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedHalfSlopeBlock::generateShapes),
    FRAMED_VERTICAL_HALF_SLOPE(false, true, false, true, false, true, false, false, ConTexMode.FULL_EDGE, FramedVerticalHalfSlopeBlock::generateShapes),
    FRAMED_DIVIDED_SLOPE(true, true, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedSlopeBlock::generateShapes),
    FRAMED_DOUBLE_HALF_SLOPE(true, false, true, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedDoubleHalfSlopeBlock::generateShapes),
    FRAMED_VERTICAL_DOUBLE_HALF_SLOPE(true, false, true, true, false, true, true, false, ConTexMode.FULL_EDGE, CommonShapes.SLAB_GENERATOR),
    FRAMED_CORNER_SLOPE(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedCornerSlopeBlock::generateCornerShapes),
    FRAMED_INNER_CORNER_SLOPE(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedCornerSlopeBlock::generateInnerCornerShapes),
    FRAMED_DOUBLE_CORNER(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_PRISM_CORNER(false, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedPrismCornerBlock::generatePrismShapes),
    FRAMED_INNER_PRISM_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedPrismCornerBlock::generateInnerPrismShapes),
    FRAMED_DOUBLE_PRISM_CORNER(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_THREEWAY_CORNER(false, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedThreewayCornerBlock::generateThreewayShapes),
    FRAMED_INNER_THREEWAY_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedThreewayCornerBlock::generateInnerThreewayShapes),
    FRAMED_DOUBLE_THREEWAY_CORNER(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_SLOPE_EDGE(false, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedSlopeEdgeBlock::generateShapes),
    FRAMED_ELEVATED_SLOPE_EDGE(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedElevatedSlopeEdgeBlock::generateShapes),
    FRAMED_ELEVATED_DOUBLE_SLOPE_EDGE(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_STACKED_SLOPE_EDGE(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedElevatedSlopeEdgeBlock::generateShapes),
    FRAMED_SLAB(true, false, false, true, true, true, false, false, ConTexMode.FULL_FACE, CommonShapes.SLAB_GENERATOR),
    FRAMED_DOUBLE_SLAB(true, false, false, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_ADJ_DOUBLE_SLAB(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_ADJ_DOUBLE_COPYCAT_SLAB(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_DIVIDED_SLAB(true, false, false, true, true, true, true, false, ConTexMode.FULL_EDGE, CommonShapes.SLAB_GENERATOR),
    FRAMED_SLAB_EDGE(false, false, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedSlabEdgeBlock::generateShapes),
    FRAMED_SLAB_CORNER(false, false, false, true, true, true, false, false, ConTexMode.DETAILED, FramedSlabCornerBlock::generateShapes),
    FRAMED_PANEL(true, false, false, true, true, true, false, false, ConTexMode.FULL_FACE, CommonShapes.PANEL_GENERATOR),
    FRAMED_DOUBLE_PANEL(true, false, false, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_ADJ_DOUBLE_PANEL(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_ADJ_DOUBLE_COPYCAT_PANEL(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_DIVIDED_PANEL_HORIZONTAL(true, false, false, true, true, true, true, false, ConTexMode.FULL_EDGE, CommonShapes.PANEL_GENERATOR),
    FRAMED_DIVIDED_PANEL_VERTICAL(true, false, false, true, true, true, true, false, ConTexMode.FULL_EDGE, CommonShapes.PANEL_GENERATOR),
    FRAMED_CORNER_PILLAR(false, false, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedCornerPillarBlock::generateShapes),
    FRAMED_STAIRS(true, false, false, true, true, true, false, true, ConTexMode.FULL_FACE),
    FRAMED_DOUBLE_STAIRS(true, false, false, false, true, true, true, true, ConTexMode.FULL_FACE),
    FRAMED_HALF_STAIRS(false, false, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedHalfStairsBlock::generateShapes),
    FRAMED_DIVIDED_STAIRS(true, false, false, true, true, true, true, true, ConTexMode.FULL_EDGE),
    FRAMED_DOUBLE_HALF_STAIRS(true, false, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedDoubleHalfStairsBlock::generateShapes),
    FRAMED_SLICED_STAIRS_SLAB(true, false, false, true, true, true, true, true, ConTexMode.FULL_FACE),
    FRAMED_SLICED_STAIRS_PANEL(true, false, false, true, true, true, true, true, ConTexMode.FULL_FACE),
    FRAMED_SLOPED_STAIRS(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedSlopedStairsBlock::generateShapes),
    FRAMED_VERTICAL_STAIRS(true, false, false, true, true, true, false, true, ConTexMode.FULL_FACE, FramedVerticalStairsBlock::generateShapes),
    FRAMED_VERTICAL_DOUBLE_STAIRS(true, false, false, false, true, true, true, true, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_VERTICAL_HALF_STAIRS(false, false, false, true, true, false, false, false, ConTexMode.FULL_EDGE, FramedVerticalHalfStairsBlock::generateShapes),
    FRAMED_VERTICAL_DIVIDED_STAIRS(true, false, false, true, true, true, true, true, ConTexMode.FULL_EDGE, FramedVerticalStairsBlock::generateShapes),
    FRAMED_VERTICAL_DOUBLE_HALF_STAIRS(true, false, false, true, true, true, true, false, ConTexMode.FULL_EDGE, CommonShapes.SLAB_GENERATOR),
    FRAMED_VERTICAL_SLICED_STAIRS(true, false, false, true, true, true, true, true, ConTexMode.FULL_FACE, FramedVerticalStairsBlock::generateShapes),
    FRAMED_VERTICAL_SLOPED_STAIRS(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedVerticalSlopedStairsBlock::generateShapes),
    FRAMED_THREEWAY_CORNER_PILLAR(false, false, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedThreewayCornerPillarBlock::generateShapes),
    FRAMED_DOUBLE_THREEWAY_CORNER_PILLAR(true, false, false, false, true, true, true, false, ConTexMode.FULL_EDGE, Shapes.block()),
    FRAMED_WALL(false, false, false, true, true, false, false, true, ConTexMode.DETAILED),
    FRAMED_FENCE(false, false, false, true, true, false, false, true, ConTexMode.DETAILED),
    FRAMED_FENCE_GATE(false, false, false, false, true, false, false, false, ConTexMode.DETAILED),
    FRAMED_DOOR(true, false, true, false, true, false, false, false, ConTexMode.FULL_FACE),
    FRAMED_IRON_DOOR(true, false, true, false, true, false, false, false, ConTexMode.FULL_FACE),
    FRAMED_TRAPDOOR(true, false, false, true, true, false, false, false, ConTexMode.FULL_FACE),
    FRAMED_IRON_TRAPDOOR(true, false, false, true, true, false, false, false, ConTexMode.FULL_FACE),
    FRAMED_PRESSURE_PLATE(false, false, false, false, true, false, false, false, null),
    FRAMED_WATERLOGGABLE_PRESSURE_PLATE(false, false, false, true, false, false, false, false, null),
    FRAMED_STONE_PRESSURE_PLATE(false, false, false, false, true, false, false, false, null),
    FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE(false, false, false, true, false, false, false, false, null),
    FRAMED_OBSIDIAN_PRESSURE_PLATE(false, false, false, false, true, false, false, false, null),
    FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE(false, false, false, true, false, false, false, false, null),
    FRAMED_GOLD_PRESSURE_PLATE(false, false, false, false, true, false, false, false, null),
    FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE(false, false, false, true, false, false, false, false, null),
    FRAMED_IRON_PRESSURE_PLATE(false, false, false, false, true, false, false, false, null),
    FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE(false, false, false, true, false, false, false, false, null),
    FRAMED_LADDER(false, false, false, true, true, false, false, false, ConTexMode.DETAILED),
    FRAMED_BUTTON(false, false, false, false, true, false, false, false, null),
    FRAMED_STONE_BUTTON(false, false, false, false, true, false, false, false, null),
    FRAMED_LARGE_BUTTON(false, false, false, false, true, false, false, false, null),
    FRAMED_LARGE_STONE_BUTTON(false, false, false, false, true, false, false, false, null),
    FRAMED_LEVER(false, false, false, false, true, false, false, false, null),
    FRAMED_SIGN(false, false, true, true, true, false, false, false, null),
    FRAMED_WALL_SIGN(false, false, true, true, false, false, false, false, null, FramedWallSignBlock::generateShapes),
    FRAMED_HANGING_SIGN(false, false, true, true, true, false, false, false, null, FramedCeilingHangingSignBlock::generateShapes),
    FRAMED_WALL_HANGING_SIGN(false, false, true, true, false, false, false, false, null),
    FRAMED_TORCH(false, false, false, false, true, false, false, false, null),
    FRAMED_WALL_TORCH(false, false, false, false, false, false, false, false, null),
    FRAMED_SOUL_TORCH(false, false, false, false, true, false, false, false, null),
    FRAMED_SOUL_WALL_TORCH(false, false, false, false, false, false, false, false, null),
    FRAMED_REDSTONE_TORCH(false, false, false, false, true, false, false, false, null),
    FRAMED_REDSTONE_WALL_TORCH(false, false, false, false, false, false, false, false, null),
    FRAMED_FLOOR_BOARD(true, false, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFloorBlock::generateShapes),
    FRAMED_WALL_BOARD(true, false, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedWallBoardBlock::generateShapes),
    FRAMED_CORNER_STRIP(false, false, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedCornerStripBlock::generateShapes),
    FRAMED_LATTICE_BLOCK(false, false, false, true, true, true, false, true, ConTexMode.DETAILED, FramedLatticeBlock::generateThinShapes),
    FRAMED_THICK_LATTICE(false, false, false, true, true, true, false, true, ConTexMode.DETAILED, FramedLatticeBlock::generateThickShapes),
    FRAMED_CHEST(false, false, true, true, true, false, false, false, null, Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)),
    FRAMED_SECRET_STORAGE(true, false, true, false, true, false, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_BARS(false, false, false, true, true, true, false, true, null),
    FRAMED_PANE(false, false, false, true, true, true, false, true, ConTexMode.DETAILED),
    FRAMED_HORIZONTAL_PANE(true, false, false, true, true, true, false, false, ConTexMode.DETAILED, Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0)),
    FRAMED_RAIL_SLOPE(true, true, false, true, true, false, false, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_POWERED_RAIL_SLOPE(true, true, false, true, true, false, false, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_DETECTOR_RAIL_SLOPE(true, true, false, true, true, false, false, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_ACTIVATOR_RAIL_SLOPE(true, true, false, true, true, false, false, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_FANCY_RAIL(false, false, false, true, true, false, false, false, null),
    FRAMED_FANCY_POWERED_RAIL(false, false, false, true, true, false, false, false, null),
    FRAMED_FANCY_DETECTOR_RAIL(false, false, false, true, true, false, false, false, null),
    FRAMED_FANCY_ACTIVATOR_RAIL(false, false, false, true, true, false, false, false, null),
    FRAMED_FANCY_RAIL_SLOPE(true, true, true, true, true, false, true, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_FANCY_POWERED_RAIL_SLOPE(true, true, true, true, true, false, true, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_FANCY_DETECTOR_RAIL_SLOPE(true, true, true, true, true, false, true, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE(true, true, true, true, true, false, true, false, ConTexMode.FULL_FACE, FramedSlopeBlock::generateShapes),
    FRAMED_FLOWER_POT(false, false, true, false, true, false, false, false, null, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0)),
    FRAMED_PILLAR(false, false, false, true, true, true, false, false, ConTexMode.DETAILED, FramedPillarBlock::generatePillarShapes),
    FRAMED_HALF_PILLAR(false, false, false, true, true, true, false, false, ConTexMode.DETAILED, FramedHalfPillarBlock::generateShapes),
    FRAMED_POST(false, false, false, true, true, true, false, false, ConTexMode.DETAILED, FramedPillarBlock::generatePostShapes),
    FRAMED_COLLAPSIBLE_BLOCK(false, true, true, true, true, true, false, false, ConTexMode.FULL_FACE),
    FRAMED_COLLAPSIBLE_COPYCAT_BLOCK(false, false, true, true, true, true, false, false, ConTexMode.FULL_FACE),
    FRAMED_BOUNCY_CUBE(true, false, false, false, true, false, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_REDSTONE_BLOCK(true, false, false, false, true, true, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_PRISM(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedPrismBlock::generateShapes),
    FRAMED_ELEVATED_INNER_PRISM(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedElevatedPrismBlock::generateInnerShapes),
    FRAMED_ELEVATED_INNER_DOUBLE_PRISM(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_SLOPED_PRISM(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedSlopedPrismBlock::generateShapes),
    FRAMED_ELEVATED_INNER_SLOPED_PRISM(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedElevatedSlopedPrismBlock::generateInnerShapes),
    FRAMED_ELEVATED_INNER_DOUBLE_SLOPED_PRISM(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_SLOPE_SLAB(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_SLOPE_SLAB(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedElevatedSlopeSlabBlock::generateShapes),
    FRAMED_COMPOUND_SLOPE_SLAB(true, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedInverseDoubleSlopeSlabBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_SLAB(true, false, true, true, true, true, true, false, ConTexMode.FULL_FACE, CommonShapes.createSlabGenerator(PropertyHolder.TOP_HALF)),
    FRAMED_INV_DOUBLE_SLOPE_SLAB(true, true, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedInverseDoubleSlopeSlabBlock::generateShapes),
    FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_STACKED_SLOPE_SLAB(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedElevatedSlopeSlabBlock::generateShapes),
    FRAMED_FLAT_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatElevatedSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatElevatedSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, true, true, true, true, false, ConTexMode.FULL_FACE, CommonShapes.createSlabGenerator(PropertyHolder.TOP_HALF)),
    FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER(true, true, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedFlatInverseDoubleSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedFlatElevatedSlopeSlabCornerBlock::generateShapes),
    FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedFlatElevatedSlopeSlabCornerBlock::generateInnerShapes),
    FRAMED_SLOPE_PANEL(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedSlopePanelBlock::generateShapes),
    FRAMED_EXTENDED_SLOPE_PANEL(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedExtendedSlopePanelBlock::generateShapes),
    FRAMED_COMPOUND_SLOPE_PANEL(true, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedInverseDoubleSlopePanelBlock::generateShapes),
    FRAMED_DOUBLE_SLOPE_PANEL(true, false, true, true, true, true, true, false, ConTexMode.FULL_FACE, CommonShapes.createPanelGenerator(FramedProperties.FACING_HOR, PropertyHolder.FRONT)),
    FRAMED_INV_DOUBLE_SLOPE_PANEL(true, true, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedInverseDoubleSlopePanelBlock::generateShapes),
    FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_STACKED_SLOPE_PANEL(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedExtendedSlopePanelBlock::generateShapes),
    FRAMED_FLAT_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatExtendedSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedFlatExtendedSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, true, true, true, true, false, ConTexMode.FULL_FACE, CommonShapes.createPanelGenerator(FramedProperties.FACING_HOR, PropertyHolder.FRONT)),
    FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER(true, true, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedFlatInverseDoubleSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedFlatExtendedSlopePanelCornerBlock::generateShapes),
    FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedFlatExtendedSlopePanelCornerBlock::generateInnerShapes),
    FRAMED_SMALL_CORNER_SLOPE_PANEL(false, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedCornerSlopePanelBlock::generateSmallShapes),
    FRAMED_SMALL_CORNER_SLOPE_PANEL_W(false, true, false, true, false, true, false, false, ConTexMode.FULL_EDGE, FramedCornerSlopePanelWallBlock::generateSmallShapes),
    FRAMED_LARGE_CORNER_SLOPE_PANEL(false, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedCornerSlopePanelBlock::generateLargeShapes),
    FRAMED_LARGE_CORNER_SLOPE_PANEL_W(false, true, false, true, false, true, false, false, ConTexMode.FULL_EDGE, FramedCornerSlopePanelWallBlock::generateLargeShapes),
    FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL(false, true, false, true, true, true, false, false, ConTexMode.FULL_EDGE, FramedCornerSlopePanelBlock::generateSmallInnerShapes),
    FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W(false, true, false, true, false, true, false, false, ConTexMode.FULL_EDGE, FramedCornerSlopePanelWallBlock::generateSmallInnerShapes),
    FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedCornerSlopePanelBlock::generateLargeInnerShapes),
    FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W(true, true, false, true, false, true, false, false, ConTexMode.FULL_FACE, FramedCornerSlopePanelWallBlock::generateLargeInnerShapes),
    FRAMED_EXT_CORNER_SLOPE_PANEL(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedExtendedCornerSlopePanelBlock::generateShapes),
    FRAMED_EXT_CORNER_SLOPE_PANEL_W(true, true, false, true, false, true, false, false, ConTexMode.FULL_FACE, FramedExtendedCornerSlopePanelWallBlock::generateShapes),
    FRAMED_EXT_INNER_CORNER_SLOPE_PANEL(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedExtendedCornerSlopePanelBlock::generateInnerShapes),
    FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W(true, true, false, true, false, true, false, false, ConTexMode.FULL_FACE, FramedExtendedCornerSlopePanelWallBlock::generateInnerShapes),
    FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL(false, false, true, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedCornerPillarBlock::generateShapes),
    FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W(false, false, true, true, false, true, true, false, ConTexMode.FULL_EDGE, FramedDoubleCornerSlopePanelWallBlock::generateSmallShapes),
    FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL(true, false, true, true, true, true, true, false, ConTexMode.FULL_FACE, FramedDoubleCornerSlopePanelBlock::generateLargeShapes),
    FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W(true, false, true, true, false, true, true, false, ConTexMode.FULL_FACE, FramedDoubleCornerSlopePanelWallBlock::generateLargeShapes),
    FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL(true, true, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedInverseDoubleCornerSlopePanelBlock::generateShapes),
    FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W(true, true, false, true, false, true, true, false, ConTexMode.FULL_EDGE, FramedInverseDoubleCornerSlopePanelWallBlock::generateShapes),
    FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W(true, false, true, false, false, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL(true, false, true, false, true, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W(true, false, true, false, false, true, true, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_STACKED_CORNER_SLOPE_PANEL(true, true, false, true, true, true, true, false, ConTexMode.FULL_EDGE, FramedExtendedCornerSlopePanelBlock::generateShapes),
    FRAMED_STACKED_CORNER_SLOPE_PANEL_W(true, true, false, true, false, true, true, false, ConTexMode.FULL_EDGE, FramedExtendedCornerSlopePanelWallBlock::generateShapes),
    FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL(true, true, false, true, true, true, true, false, ConTexMode.FULL_FACE, FramedExtendedCornerSlopePanelBlock::generateInnerShapes),
    FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W(true, true, false, true, false, true, true, false, ConTexMode.FULL_FACE, FramedExtendedCornerSlopePanelWallBlock::generateInnerShapes),
    FRAMED_GLOWING_CUBE(true, false, false, false, true, true, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_PYRAMID(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedPyramidBlock::generateShapes),
    FRAMED_PYRAMID_SLAB(true, true, false, true, true, true, false, false, ConTexMode.FULL_FACE, FramedPyramidBlock::generateSlabShapes),
    FRAMED_TARGET(true, false, true, false, true, true, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_GATE(true, false, false, false, true, false, false, false, ConTexMode.FULL_FACE, FramedGateBlock::generateShapes),
    FRAMED_IRON_GATE(true, false, false, false, true, false, false, false, ConTexMode.FULL_FACE, FramedGateBlock::generateShapes),
    FRAMED_ITEM_FRAME(false, true, true, false, true, false, false, false, null, FramedItemFrameBlock::generateShapes),
    FRAMED_GLOWING_ITEM_FRAME(false, true, true, false, true, false, false, false, null, FramedItemFrameBlock::generateShapes),
    FRAMED_MINI_CUBE(false, false, false, true, true, true, false, false, null, Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)),
    FRAMED_ONE_WAY_WINDOW(false, false, true, false, true, false, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_BOOKSHELF(true, false, false, false, true, true, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_CHISELED_BOOKSHELF(true, false, true, false, true, true, false, false, ConTexMode.FULL_FACE, Shapes.block()),
    FRAMED_CENTERED_SLAB(true, false, false, true, true, true, false, false, ConTexMode.DETAILED, Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0)),
    FRAMED_CENTERED_PANEL(true, false, false, true, true, true, false, false, ConTexMode.DETAILED, FramedCenteredPanelBlock::generateShapes),
    FRAMED_MASONRY_CORNER_SEGMENT(false, false, false, true, false, true, false, false, ConTexMode.FULL_EDGE, FramedMasonryCornerSegmentBlock::generateShapes),
    FRAMED_MASONRY_CORNER(true, false, false, false, true, true, true, false, ConTexMode.FULL_EDGE, Shapes.block()),
    FRAMED_CHECKERED_CUBE_SEGMENT(false, false, false, true, false, true, false, false, ConTexMode.DETAILED, FramedCheckeredCubeSegmentBlock::generateShapes),
    FRAMED_CHECKERED_CUBE(true, false, false, false, true, true, true, false, ConTexMode.DETAILED, Shapes.block()),
    FRAMED_CHECKERED_SLAB_SEGMENT(false, false, false, true, false, true, false, false, ConTexMode.DETAILED, FramedCheckeredSlabSegmentBlock::generateShapes),
    FRAMED_CHECKERED_SLAB(true, false, false, true, true, true, true, false, ConTexMode.DETAILED, CommonShapes.SLAB_GENERATOR),
    FRAMED_CHECKERED_PANEL_SEGMENT(false, false, false, true, false, true, false, false, ConTexMode.DETAILED, FramedCheckeredPanelSegmentBlock::generateShapes),
    FRAMED_CHECKERED_PANEL(true, false, false, true, true, true, true, false, ConTexMode.DETAILED, CommonShapes.PANEL_GENERATOR),
    FRAMED_TUBE(true, false, false, true, true, false, false, false, ConTexMode.FULL_FACE, FramedTubeBlock::generateShapes);

    private final String name = this.toString().toLowerCase(Locale.ROOT);
    private final boolean canOcclude;
    private final boolean specialHitbox;
    private final boolean specialTile;
    private final boolean waterloggable;
    private final boolean blockItem;
    private final boolean allowIntangible;
    private final boolean doubleBlock;
    private final boolean lockable;
    private final boolean supportsCT;
    private final ConTexMode minCTMode;
    private final ShapeGenerator shapeGen;

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, @Nullable boolean doubleBlock, boolean lockable, ConTexMode minCTMode) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, minCTMode, ShapeGenerator.EMPTY);
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, @Nullable boolean doubleBlock, boolean lockable, ConTexMode minCTMode, VoxelShape shape) {
        this(canOcclude, specialHitbox, specialTile, waterloggable, blockItem, allowIntangible, doubleBlock, lockable, minCTMode, ShapeGenerator.singleShape(shape));
        Preconditions.checkArgument((!waterloggable || !Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.block(), (BooleanOp)BooleanOp.NOT_SAME).isEmpty() ? 1 : 0) != 0, (Object)"Blocks with full cube shape can't be waterloggable");
    }

    private BlockType(boolean canOcclude, boolean specialHitbox, boolean specialTile, boolean waterloggable, boolean blockItem, boolean allowIntangible, @Nullable boolean doubleBlock, boolean lockable, ConTexMode minCTMode, ShapeGenerator shapeGen) {
        this.canOcclude = canOcclude;
        this.specialHitbox = specialHitbox;
        this.specialTile = specialTile;
        this.waterloggable = waterloggable;
        this.blockItem = blockItem;
        this.allowIntangible = allowIntangible;
        this.doubleBlock = doubleBlock;
        this.lockable = lockable;
        this.supportsCT = minCTMode != null;
        this.minCTMode = Objects.requireNonNullElse(minCTMode, ConTexMode.NONE);
        this.shapeGen = shapeGen;
    }

    @Override
    public boolean canOccludeWithSolidCamo() {
        return this.canOcclude;
    }

    @Override
    public boolean hasSpecialHitbox() {
        return this.specialHitbox;
    }

    @Override
    public FullFacePredicate getFullFacePredicate() {
        return (FullFacePredicate)FullFacePredicates.PREDICATES.get(this);
    }

    @Override
    public SideSkipPredicate getSideSkipPredicate() {
        return (SideSkipPredicate)SideSkipPredicates.PREDICATES.get(this);
    }

    @Override
    public ConnectionPredicate getConnectionPredicate() {
        return (ConnectionPredicate)ConnectionPredicates.PREDICATES.get(this);
    }

    @Override
    public ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        if (!FMLEnvironment.production) {
            return new ReloadableShapeProvider(this.shapeGen, states);
        }
        return this.shapeGen.generate(states);
    }

    @Override
    public boolean hasSpecialTile() {
        return this.specialTile;
    }

    @Override
    public boolean hasBlockItem() {
        return this.blockItem;
    }

    @Override
    public boolean supportsWaterLogging() {
        return this.waterloggable;
    }

    @Override
    public boolean supportsConnectedTextures() {
        return this.supportsCT;
    }

    @Override
    public ConTexMode getMinimumConTexMode() {
        return this.minCTMode;
    }

    @Override
    public boolean allowMakingIntangible() {
        return this.allowIntangible;
    }

    @Override
    public boolean isDoubleBlock() {
        return this.doubleBlock;
    }

    @Override
    public boolean canLockState() {
        return this.lockable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(IBlockType other) {
        if (!(other instanceof BlockType)) {
            return 1;
        }
        BlockType type = (BlockType)other;
        return this.compareTo(type);
    }
}

