/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.config;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.config.ExtConfigView;

public final class ServerConfig {
    public static final ExtConfigView.Server VIEW = (ExtConfigView.Server)ConfigView.Server.INSTANCE;
    private static ModConfigSpec spec;
    private static final String KEY_ALLOW_BLOCK_ENTITIES = "allowBlockEntities";
    private static final String KEY_ENABLE_INTANGIBILITY = "enableIntangibleFeature";
    private static final String KEY_INTANGIBLE_MARKER = "intangibleMarkerItem";
    private static final String KEY_ONE_WAY_WINDOW_OWNABLE = "oneWayWindowOwnable";
    private static final String KEY_CONSUME_CAMO_ITEM = "consumeCamoItem";
    private static final String KEY_GLOWSTONE_LIGHT_LEVEL = "glowstoneLightLevel";
    private static final String KEY_FIREPROOF_BLOCKS = "fireproofBlocks";
    private static final String KEY_POWERED_SAW_ENERGY_CAPACITY = "energyCapacity";
    private static final String KEY_POWERED_SAW_MAX_RECEIVE = "maxReceive";
    private static final String KEY_POWERED_SAW_CONSUMPTION = "consumption";
    private static final String KEY_POWERED_SAW_RECIPE_DURATION = "craftingDuration";
    public static final String TRANSLATION_ALLOW_BLOCK_ENTITIES;
    public static final String TRANSLATION_ENABLE_INTANGIBILITY;
    public static final String TRANSLATION_INTANGIBLE_MARKER;
    public static final String TRANSLATION_ONE_WAY_WINDOW_OWNABLE;
    public static final String TRANSLATION_CONSUME_CAMO_ITEM;
    public static final String TRANSLATION_GLOWSTONE_LIGHT_LEVEL;
    public static final String TRANSLATION_FIREPROOF_BLOCKS;
    public static final String TRANSLATION_POWERED_SAW_ENERGY_CAPACITY;
    public static final String TRANSLATION_POWERED_SAW_MAX_RECEIVE;
    public static final String TRANSLATION_POWERED_SAW_CONSUMPTION;
    public static final String TRANSLATION_POWERED_SAW_RECIPE_DURATION;
    private static boolean allowBlockEntities;
    private static boolean enableIntangibleFeature;
    private static Item intangibleMarkerItem;
    private static boolean oneWayWindowOwnable;
    private static boolean consumeCamoItem;
    private static int glowstoneLightLevel;
    private static boolean fireproofBlocks;
    private static int poweredSawEnergyCapacity;
    private static int poweredSawMaxReceive;
    private static int poweredSawConsumption;
    private static int poweredSawRecipeDuration;
    private static ModConfigSpec.BooleanValue allowBlockEntitiesValue;
    private static ModConfigSpec.BooleanValue enableIntangibleFeatureValue;
    private static ModConfigSpec.ConfigValue<String> intangibleMarkerItemValue;
    private static ModConfigSpec.BooleanValue oneWayWindowOwnableValue;
    private static ModConfigSpec.BooleanValue consumeCamoItemValue;
    private static ModConfigSpec.IntValue glowstoneLightLevelValue;
    private static ModConfigSpec.BooleanValue fireproofBlocksValue;
    private static ModConfigSpec.IntValue poweredSawEnergyCapacityValue;
    private static ModConfigSpec.IntValue poweredSawMaxReceiveValue;
    private static ModConfigSpec.IntValue poweredSawConsumptionValue;
    private static ModConfigSpec.IntValue poweredSawRecipeDurationValue;

    public static ModConfigSpec create(IEventBus modBus) {
        modBus.addListener(event -> ServerConfig.onConfigReloaded((ModConfigEvent)event));
        modBus.addListener(event -> ServerConfig.onConfigReloaded((ModConfigEvent)event));
        spec = (ModConfigSpec)new ModConfigSpec.Builder().configure(ServerConfig::build).getRight();
        return spec;
    }

    private static Object build(ModConfigSpec.Builder builder) {
        builder.push("general");
        allowBlockEntitiesValue = builder.comment("Whether blocks with block entities can be placed in framed blocks").translation(TRANSLATION_ALLOW_BLOCK_ENTITIES).define(KEY_ALLOW_BLOCK_ENTITIES, false);
        enableIntangibleFeatureValue = builder.comment("Enables the intangbility feature. Disabling this also prevents moving through blocks that are already marked as intangible").translation(TRANSLATION_ENABLE_INTANGIBILITY).define(KEY_ENABLE_INTANGIBILITY, false);
        intangibleMarkerItemValue = builder.comment("The item to use for making Framed Blocks intangible. The value must be a valid item registry name").translation(TRANSLATION_INTANGIBLE_MARKER).define(KEY_INTANGIBLE_MARKER, (Object)BuiltInRegistries.ITEM.getKey((Object)Items.PHANTOM_MEMBRANE).toString(), ServerConfig::validateItemName);
        oneWayWindowOwnableValue = builder.comment("If true, only the player who placed the Framed One-Way Window can modify the window direction").translation(TRANSLATION_ONE_WAY_WINDOW_OWNABLE).define(KEY_ONE_WAY_WINDOW_OWNABLE, true);
        consumeCamoItemValue = builder.comment("If true, applying a camo will consume the item and removing the camo will drop it again").translation(TRANSLATION_CONSUME_CAMO_ITEM).define(KEY_CONSUME_CAMO_ITEM, true);
        glowstoneLightLevelValue = builder.comment("The light level to emit when glowstone dust is applied to a framed block").translation(TRANSLATION_GLOWSTONE_LIGHT_LEVEL).defineInRange(KEY_GLOWSTONE_LIGHT_LEVEL, 15, 0, 15);
        fireproofBlocksValue = builder.comment("If true, framed blocks are completely fire proof").translation(TRANSLATION_FIREPROOF_BLOCKS).define(KEY_FIREPROOF_BLOCKS, false);
        builder.pop();
        builder.push("powered_framing_saw");
        poweredSawEnergyCapacityValue = builder.comment("The amount of power the Powered Framing Saw can store").translation(TRANSLATION_POWERED_SAW_ENERGY_CAPACITY).defineInRange(KEY_POWERED_SAW_ENERGY_CAPACITY, 5000, 100, Short.MAX_VALUE);
        poweredSawMaxReceiveValue = builder.comment("The amount of power the Powered Framing Saw can receive per tick").translation(TRANSLATION_POWERED_SAW_MAX_RECEIVE).defineInRange(KEY_POWERED_SAW_MAX_RECEIVE, 250, 10, Short.MAX_VALUE);
        poweredSawConsumptionValue = builder.comment("The amount of power the Powered Framing Saw consumes per tick while crafting").translation(TRANSLATION_POWERED_SAW_CONSUMPTION).defineInRange(KEY_POWERED_SAW_CONSUMPTION, 50, 1, Short.MAX_VALUE);
        poweredSawRecipeDurationValue = builder.comment("How many ticks the Powered Framing Saw takes per crafting operation").translation(TRANSLATION_POWERED_SAW_RECIPE_DURATION).defineInRange(KEY_POWERED_SAW_RECIPE_DURATION, 30, 5, 200);
        builder.pop();
        return null;
    }

    private static boolean validateItemName(Object obj) {
        String name;
        ResourceLocation key;
        if (obj instanceof String && (key = ResourceLocation.tryParse((String)(name = (String)obj))) != null && BuiltInRegistries.ITEM.containsKey(key)) {
            return BuiltInRegistries.ITEM.get(key) != Items.AIR;
        }
        return false;
    }

    private static String translate(String key) {
        return Utils.translateConfig("server", key);
    }

    private static void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER && event.getConfig().getSpec() == spec) {
            allowBlockEntities = (Boolean)allowBlockEntitiesValue.get();
            enableIntangibleFeature = (Boolean)enableIntangibleFeatureValue.get();
            intangibleMarkerItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)((String)intangibleMarkerItemValue.get())));
            oneWayWindowOwnable = (Boolean)oneWayWindowOwnableValue.get();
            consumeCamoItem = (Boolean)consumeCamoItemValue.get();
            glowstoneLightLevel = (Integer)glowstoneLightLevelValue.get();
            fireproofBlocks = (Boolean)fireproofBlocksValue.get();
            poweredSawEnergyCapacity = (Integer)poweredSawEnergyCapacityValue.get();
            poweredSawMaxReceive = (Integer)poweredSawMaxReceiveValue.get();
            poweredSawConsumption = (Integer)poweredSawConsumptionValue.get();
            poweredSawRecipeDuration = (Integer)poweredSawRecipeDurationValue.get();
        }
    }

    private ServerConfig() {
    }

    static {
        TRANSLATION_ALLOW_BLOCK_ENTITIES = ServerConfig.translate(KEY_ALLOW_BLOCK_ENTITIES);
        TRANSLATION_ENABLE_INTANGIBILITY = ServerConfig.translate(KEY_ENABLE_INTANGIBILITY);
        TRANSLATION_INTANGIBLE_MARKER = ServerConfig.translate(KEY_INTANGIBLE_MARKER);
        TRANSLATION_ONE_WAY_WINDOW_OWNABLE = ServerConfig.translate(KEY_ONE_WAY_WINDOW_OWNABLE);
        TRANSLATION_CONSUME_CAMO_ITEM = ServerConfig.translate(KEY_CONSUME_CAMO_ITEM);
        TRANSLATION_GLOWSTONE_LIGHT_LEVEL = ServerConfig.translate(KEY_GLOWSTONE_LIGHT_LEVEL);
        TRANSLATION_FIREPROOF_BLOCKS = ServerConfig.translate(KEY_FIREPROOF_BLOCKS);
        TRANSLATION_POWERED_SAW_ENERGY_CAPACITY = ServerConfig.translate(KEY_POWERED_SAW_ENERGY_CAPACITY);
        TRANSLATION_POWERED_SAW_MAX_RECEIVE = ServerConfig.translate(KEY_POWERED_SAW_MAX_RECEIVE);
        TRANSLATION_POWERED_SAW_CONSUMPTION = ServerConfig.translate(KEY_POWERED_SAW_CONSUMPTION);
        TRANSLATION_POWERED_SAW_RECIPE_DURATION = ServerConfig.translate(KEY_POWERED_SAW_RECIPE_DURATION);
        allowBlockEntities = false;
        enableIntangibleFeature = false;
        intangibleMarkerItem = Items.PHANTOM_MEMBRANE;
        oneWayWindowOwnable = true;
        consumeCamoItem = true;
        glowstoneLightLevel = 15;
        fireproofBlocks = false;
        poweredSawEnergyCapacity = 0;
        poweredSawMaxReceive = 0;
        poweredSawConsumption = 0;
        poweredSawRecipeDuration = 0;
    }

    public static final class ViewImpl
    implements ExtConfigView.Server {
        private static boolean overrideIntangibilityConfig = false;

        @Override
        public boolean allowBlockEntities() {
            return allowBlockEntities;
        }

        @Override
        public void setOverrideIntangibilityConfig(boolean override) {
            overrideIntangibilityConfig = override;
        }

        @Override
        public boolean enableIntangibility() {
            return overrideIntangibilityConfig || enableIntangibleFeature;
        }

        @Override
        public Item getIntangibilityMarkerItem() {
            return intangibleMarkerItem;
        }

        @Override
        public boolean isOneWayWindowOwnable() {
            return oneWayWindowOwnable;
        }

        @Override
        public boolean shouldConsumeCamoItem() {
            return consumeCamoItem;
        }

        @Override
        public int getGlowstoneLightLevel() {
            return glowstoneLightLevel;
        }

        @Override
        public boolean areBlocksFireproof() {
            return fireproofBlocks;
        }

        @Override
        public int getPoweredSawEnergyCapacity() {
            return poweredSawEnergyCapacity;
        }

        @Override
        public int getPoweredSawMaxInput() {
            return poweredSawMaxReceive;
        }

        @Override
        public int getPoweredSawConsumption() {
            return poweredSawConsumption;
        }

        @Override
        public int getPoweredSawCraftingDuration() {
            return poweredSawRecipeDuration;
        }
    }
}

