/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.config;

import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.util.CamoMessageVerbosity;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.SolidFrameMode;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.common.config.ExtConfigView;

public final class ClientConfig {
    public static final ExtConfigView.Client VIEW = (ExtConfigView.Client)ConfigView.Client.INSTANCE;
    private static ModConfigSpec spec;
    private static final String KEY_SHOW_GHOST_BLOCKS = "showGhostBlocks";
    private static final String KEY_ALT_GHOST_RENDERER = "altGhostRenderer";
    private static final String KEY_GHOST_RENDER_OPACITY = "ghostRenderOpacity";
    private static final String KEY_FANCY_HITBOXES = "fancyHitboxes";
    private static final String KEY_DETAILED_CULLING = "detailedCulling";
    private static final String KEY_USE_DISCRETE_UV_STEPS = "discreteUVSteps";
    private static final String KEY_CON_TEX_MODE = "conTexMode";
    private static final String KEY_CAMO_MESSAGE_VERBOSITY = "camoMessageVerbosity";
    private static final String KEY_FORCE_AO_ON_GLOWING_BLOCKS = "forceAoOnGlowingBlocks";
    private static final String KEY_RENDER_ITEM_MODELS_WITH_CAMO = "renderItemModelsWithCamo";
    private static final String KEY_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI = "showAllRecipePermutationsInEmi";
    private static final String KEY_SOLID_FRAME_MODE = "solidFrameMode";
    private static final String KEY_SHOW_BUTTON_PLATE_OVERLAY = "showButtonPlateTypeOverlay";
    private static final String KEY_SHOW_SPECIAL_CUBE_OVERLAY = "showSpecialCubeTypeOverlay";
    private static final String KEY_RENDER_CAMO_IN_JADE = "renderCamoInJade";
    private static final String KEY_STATE_LOCK_MODE = "stateLockMode";
    private static final String KEY_TOGGLE_WATERLOG_MODE = "toggleWaterlogMode";
    private static final String KEY_TOGGLE_Y_SLOPE_MODE = "toggleYSlopeMode";
    private static final String KEY_REINFORCEMENT_MODE = "reinforcedMode";
    private static final String KEY_PRISM_OFFSET_MODE = "prismOffsetMode";
    private static final String KEY_SPLIT_LINES_MODE = "splitLineMode";
    private static final String KEY_ONE_WAY_WINDOW_MODE = "oneWayWindowMode";
    private static final String KEY_FRAME_BACKGROUND_MODE = "itemFrameBackgroundMode";
    private static final String KEY_CAMO_ROTATION_MODE = "camoRotationMode";
    public static final String TRANSLATION_SHOW_GHOST_BLOCKS;
    public static final String TRANSLATION_ALT_GHOST_RENDERER;
    public static final String TRANSLATION_GHOST_RENDER_OPACITY;
    public static final String TRANSLATION_FANCY_HITBOXES;
    public static final String TRANSLATION_DETAILED_CULLING;
    public static final String TRANSLATION_USE_DISCRETE_UV_STEPS;
    public static final String TRANSLATION_CON_TEX_MODE;
    public static final String TRANSLATION_CAMO_MESSAGE_VERBOSITY;
    public static final String TRANSLATION_FORCE_AO_ON_GLOWING_BLOCKS;
    public static final String TRANSLATION_RENDER_ITEM_MODELS_WITH_CAMO;
    public static final String TRANSLATION_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI;
    public static final String TRANSLATION_SOLID_FRAME_MODE;
    public static final String TRANSLATION_SHOW_BUTTON_PLATE_OVERLAY;
    public static final String TRANSLATION_SHOW_SPECIAL_CUBE_OVERLAY;
    public static final String TRANSLATION_RENDER_CAMO_IN_JADE;
    public static final String TRANSLATION_STATE_LOCK_MODE;
    public static final String TRANSLATION_TOGGLE_WATERLOG_MODE;
    public static final String TRANSLATION_TOGGLE_Y_SLOPE_MODE;
    public static final String TRANSLATION_REINFORCEMENT_MODE;
    public static final String TRANSLATION_PRISM_OFFSET_MODE;
    public static final String TRANSLATION_SPLIT_LINES_MODE;
    public static final String TRANSLATION_ONE_WAY_WINDOW_MODE;
    public static final String TRANSLATION_FRAME_BACKGROUND_MODE;
    public static final String TRANSLATION_CAMO_ROTATION_MODE;
    private static final String COMMENT_OVERLAY_HIDDEN = "If set to HIDDEN, the %s overlay will be completely hidden";
    private static final String COMMENT_OVERLAY_ICON = "If set to ICON, the %s overlay will only show an icon";
    private static final String COMMENT_OVERLAY_DETAILED = "If set to DETAILED, the %s overlay will show detailed info";
    private static boolean showGhostBlocks;
    private static boolean altGhostRenderer;
    private static int ghostRenderOpacity;
    private static boolean fancyHitboxes;
    private static boolean detailedCulling;
    private static boolean useDiscreteUVSteps;
    private static ConTexMode conTexMode;
    private static CamoMessageVerbosity camoMessageVerbosity;
    private static boolean forceAoOnGlowingBlocks;
    private static boolean renderItemModelsWithCamo;
    private static boolean showAllRecipePermutationsInEmi;
    private static SolidFrameMode solidFrameMode;
    private static boolean showButtonPlateOverlay;
    private static boolean showSpecialCubeOverlay;
    private static boolean renderCamoInJade;
    private static BlockInteractOverlay.Mode stateLockMode;
    private static BlockInteractOverlay.Mode toggleWaterlogMode;
    private static BlockInteractOverlay.Mode toggleYSlopeMode;
    private static BlockInteractOverlay.Mode reinforcementMode;
    private static BlockInteractOverlay.Mode prismOffsetMode;
    private static BlockInteractOverlay.Mode splitLineMode;
    private static BlockInteractOverlay.Mode oneWayWindowMode;
    private static BlockInteractOverlay.Mode frameBackgroundMode;
    private static BlockInteractOverlay.Mode camoRotationMode;
    private static ModConfigSpec.BooleanValue showGhostBlocksValue;
    private static ModConfigSpec.BooleanValue altGhostRendererValue;
    private static ModConfigSpec.IntValue ghostRenderOpacityValue;
    private static ModConfigSpec.BooleanValue fancyHitboxesValue;
    private static ModConfigSpec.BooleanValue detailedCullingValue;
    private static ModConfigSpec.BooleanValue useDiscreteUVStepsValue;
    private static ModConfigSpec.EnumValue<ConTexMode> conTexModeValue;
    private static ModConfigSpec.EnumValue<CamoMessageVerbosity> camoMessageVerbosityValue;
    private static ModConfigSpec.BooleanValue forceAoOnGlowingBlocksValue;
    private static ModConfigSpec.BooleanValue renderItemModelsWithCamoValue;
    private static ModConfigSpec.BooleanValue showAllRecipePermutationsInEmiValue;
    private static ModConfigSpec.EnumValue<SolidFrameMode> solidFrameModeValue;
    private static ModConfigSpec.BooleanValue showButtonPlateOverlayValue;
    private static ModConfigSpec.BooleanValue showSpecialCubeOverlayValue;
    private static ModConfigSpec.BooleanValue renderCamoInJadeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> stateLockModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> toggleWaterlogModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> toggleYSlopeModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> reinforcementModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> prismOffsetModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> splitLineModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> oneWayWindowModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> frameBackgroundModeValue;
    private static ModConfigSpec.EnumValue<BlockInteractOverlay.Mode> camoRotationModeValue;

    public static ModConfigSpec create(IEventBus modBus) {
        modBus.addListener(event -> ClientConfig.onConfigReloaded((ModConfigEvent)event));
        modBus.addListener(event -> ClientConfig.onConfigReloaded((ModConfigEvent)event));
        spec = (ModConfigSpec)new ModConfigSpec.Builder().configure(ClientConfig::build).getRight();
        return spec;
    }

    private static Object build(ModConfigSpec.Builder builder) {
        builder.push("general");
        showGhostBlocksValue = builder.comment("Whether ghost blocks are shown when you are holding a framed block").translation(TRANSLATION_SHOW_GHOST_BLOCKS).define(KEY_SHOW_GHOST_BLOCKS, true);
        altGhostRendererValue = builder.comment("If true, an alternate renderer will be used for the placement preview. May solve issues with certain shaders").translation(TRANSLATION_ALT_GHOST_RENDERER).define(KEY_ALT_GHOST_RENDERER, false);
        ghostRenderOpacityValue = builder.comment("Set the opacity of the placement preview. 30 is almost completely transparent, 255 is fully opaque").translation(TRANSLATION_GHOST_RENDER_OPACITY).defineInRange(KEY_GHOST_RENDER_OPACITY, 170, 30, 255);
        fancyHitboxesValue = builder.comment("Whether certain framed blocks should show fancy hitboxes").translation(TRANSLATION_FANCY_HITBOXES).define(KEY_FANCY_HITBOXES, true);
        detailedCullingValue = builder.comment("If false only full block faces of framed blocks will be culled, if true all outer faces of famed blocks can be culled").translation(TRANSLATION_DETAILED_CULLING).define(KEY_DETAILED_CULLING, true);
        useDiscreteUVStepsValue = builder.comment("If true, the UV remapping will use discrete steps to avoid floating point errors").translation(TRANSLATION_USE_DISCRETE_UV_STEPS).define(KEY_USE_DISCRETE_UV_STEPS, true);
        conTexModeValue = builder.comment(new String[]{"Configures how detailed connected textures are supported.", "Use anything above FULL_EDGE at your own risk (performance impact, unexpected behaviour)!", "If NONE, all connected textures support is disabled", "If FULL_FACE, connected textures are supported on full faces", "If FULL_EDGE, connected textures are supported as above and on faces whose connecting edge covers the full block width", "If DETAILED, connected textures are supported as above and on most faces when interacting with other framed blocks"}).translation(TRANSLATION_CON_TEX_MODE).defineEnum(KEY_CON_TEX_MODE, (Enum)ConTexMode.DETAILED);
        camoMessageVerbosityValue = builder.comment(new String[]{"Configures the verbosity of messages displayed when a block cannot be used as a camo", "If NONE, no message will be shown", "If DEFAULT, a message will be shown when the block has a BlockEntity and isn't explicitly allowed or the block is explicitly disallowed", "If DETAILED, a message will be shown as above or when a block is non-solid and not explicitly allowed"}).translation(TRANSLATION_CAMO_MESSAGE_VERBOSITY).defineEnum(KEY_CAMO_MESSAGE_VERBOSITY, (Enum)CamoMessageVerbosity.DEFAULT);
        forceAoOnGlowingBlocksValue = builder.comment(new String[]{"If true, ambient occlusion is applied to framed blocks which glow from applied glowstone dust.", "If false, the vanilla behavior of disabling AO for light-emitting blocks is used"}).translation(TRANSLATION_FORCE_AO_ON_GLOWING_BLOCKS).define(KEY_FORCE_AO_ON_GLOWING_BLOCKS, true);
        renderItemModelsWithCamoValue = builder.comment(new String[]{"If true, item models will be rendered with their camo, if present.", "If false, item models will always be rendered without camo"}).translation(TRANSLATION_RENDER_ITEM_MODELS_WITH_CAMO).define(KEY_RENDER_ITEM_MODELS_WITH_CAMO, true);
        showAllRecipePermutationsInEmiValue = builder.comment("If true, all possible recipes of the Framing Saw will be added to EMI, else only the permutations using the Framed Cube will be added").comment("This setting only has an effect when EMI is installed").translation(TRANSLATION_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI).define(KEY_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI, true);
        solidFrameModeValue = builder.comment(new String[]{"Configures in which cases a framed block without a camo gets a solid model", "If NEVER, the default frame texture will always be used", "If DEFAULT, certain blocks will use the default frame texture with a solid background texture", "If ALWAYS, all blocks will use the default frame texture with a solid background texture"}).translation(TRANSLATION_SOLID_FRAME_MODE).defineEnum(KEY_SOLID_FRAME_MODE, (Enum)SolidFrameMode.DEFAULT);
        showButtonPlateOverlayValue = builder.comment(new String[]{"If enabled, non-wooden buttons and pressure plates will show a material overlay when a camo is applied", "Requires resource reload to take effect"}).translation(TRANSLATION_SHOW_BUTTON_PLATE_OVERLAY).define(KEY_SHOW_BUTTON_PLATE_OVERLAY, true);
        showSpecialCubeOverlayValue = builder.comment(new String[]{"If enabled, special cube blocks will show a type overlay when a camo is applied", "Requires resource reload to take effect"}).translation(TRANSLATION_SHOW_SPECIAL_CUBE_OVERLAY).define(KEY_SHOW_SPECIAL_CUBE_OVERLAY, true);
        renderCamoInJadeValue = builder.comment("If true, framed blocks will be rendered with their camo in Jade, otherwise they will be rendered blank").translation(TRANSLATION_RENDER_CAMO_IN_JADE).define(KEY_RENDER_CAMO_IN_JADE, true);
        builder.pop();
        builder.push("overlay");
        stateLockModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("State Lock")).comment(COMMENT_OVERLAY_ICON.formatted("State Lock")).comment(COMMENT_OVERLAY_DETAILED.formatted("State Lock")).translation(TRANSLATION_STATE_LOCK_MODE).defineEnum(KEY_STATE_LOCK_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        toggleWaterlogModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Toggle Waterloggable")).comment(COMMENT_OVERLAY_ICON.formatted("Toggle Waterloggable")).comment(COMMENT_OVERLAY_DETAILED.formatted("Toggle Waterloggable")).translation(TRANSLATION_TOGGLE_WATERLOG_MODE).defineEnum(KEY_TOGGLE_WATERLOG_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        toggleYSlopeModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Toggle Slope Face")).comment(COMMENT_OVERLAY_ICON.formatted("Toggle Slope Face")).comment(COMMENT_OVERLAY_DETAILED.formatted("Toggle Slope Face")).translation(TRANSLATION_TOGGLE_Y_SLOPE_MODE).defineEnum(KEY_TOGGLE_Y_SLOPE_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        reinforcementModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Reinforcement")).comment(COMMENT_OVERLAY_ICON.formatted("Reinforcement")).comment(COMMENT_OVERLAY_DETAILED.formatted("Reinforcement")).translation(TRANSLATION_REINFORCEMENT_MODE).defineEnum(KEY_REINFORCEMENT_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        prismOffsetModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Prism Offset")).comment(COMMENT_OVERLAY_ICON.formatted("Prism Offset")).comment(COMMENT_OVERLAY_DETAILED.formatted("Prism Offset")).translation(TRANSLATION_PRISM_OFFSET_MODE).defineEnum(KEY_PRISM_OFFSET_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        splitLineModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Collapsible Block Split Line")).comment(COMMENT_OVERLAY_ICON.formatted("Collapsible Block Split Line")).comment(COMMENT_OVERLAY_DETAILED.formatted("Collapsible Block Split Line")).translation(TRANSLATION_SPLIT_LINES_MODE).defineEnum(KEY_SPLIT_LINES_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        oneWayWindowModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("One-Way Window")).comment(COMMENT_OVERLAY_ICON.formatted("One-Way Window")).comment(COMMENT_OVERLAY_DETAILED.formatted("One-Way Window")).translation(TRANSLATION_ONE_WAY_WINDOW_MODE).defineEnum(KEY_ONE_WAY_WINDOW_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        frameBackgroundModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Item Frame Background")).comment(COMMENT_OVERLAY_ICON.formatted("Item Frame Background")).comment(COMMENT_OVERLAY_DETAILED.formatted("Item Frame Background")).translation(TRANSLATION_FRAME_BACKGROUND_MODE).defineEnum(KEY_FRAME_BACKGROUND_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        camoRotationModeValue = builder.comment(COMMENT_OVERLAY_HIDDEN.formatted("Camo Rotation")).comment(COMMENT_OVERLAY_ICON.formatted("Camo Rotation")).comment(COMMENT_OVERLAY_DETAILED.formatted("Camo Rotation")).translation(TRANSLATION_CAMO_ROTATION_MODE).defineEnum(KEY_CAMO_ROTATION_MODE, (Enum)BlockInteractOverlay.Mode.DETAILED);
        builder.pop();
        return null;
    }

    private static String translate(String key) {
        return Utils.translateConfig("client", key);
    }

    private static void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && event.getConfig().getSpec() == spec) {
            showGhostBlocks = (Boolean)showGhostBlocksValue.get();
            altGhostRenderer = (Boolean)altGhostRendererValue.get();
            ghostRenderOpacity = (Integer)ghostRenderOpacityValue.get();
            fancyHitboxes = (Boolean)fancyHitboxesValue.get();
            detailedCulling = (Boolean)detailedCullingValue.get();
            useDiscreteUVSteps = (Boolean)useDiscreteUVStepsValue.get();
            conTexMode = (ConTexMode)((Object)conTexModeValue.get());
            camoMessageVerbosity = (CamoMessageVerbosity)((Object)camoMessageVerbosityValue.get());
            forceAoOnGlowingBlocks = (Boolean)forceAoOnGlowingBlocksValue.get();
            renderItemModelsWithCamo = (Boolean)renderItemModelsWithCamoValue.get();
            showAllRecipePermutationsInEmi = (Boolean)showAllRecipePermutationsInEmiValue.get();
            solidFrameMode = (SolidFrameMode)((Object)solidFrameModeValue.get());
            showButtonPlateOverlay = (Boolean)showButtonPlateOverlayValue.get();
            showSpecialCubeOverlay = (Boolean)showSpecialCubeOverlayValue.get();
            renderCamoInJade = (Boolean)renderCamoInJadeValue.get();
            stateLockMode = (BlockInteractOverlay.Mode)((Object)stateLockModeValue.get());
            toggleWaterlogMode = (BlockInteractOverlay.Mode)((Object)toggleWaterlogModeValue.get());
            toggleYSlopeMode = (BlockInteractOverlay.Mode)((Object)toggleYSlopeModeValue.get());
            reinforcementMode = (BlockInteractOverlay.Mode)((Object)reinforcementModeValue.get());
            prismOffsetMode = (BlockInteractOverlay.Mode)((Object)prismOffsetModeValue.get());
            splitLineMode = (BlockInteractOverlay.Mode)((Object)splitLineModeValue.get());
            oneWayWindowMode = (BlockInteractOverlay.Mode)((Object)oneWayWindowModeValue.get());
            frameBackgroundMode = (BlockInteractOverlay.Mode)((Object)frameBackgroundModeValue.get());
            camoRotationMode = (BlockInteractOverlay.Mode)((Object)camoRotationModeValue.get());
        }
    }

    private ClientConfig() {
    }

    static {
        TRANSLATION_SHOW_GHOST_BLOCKS = ClientConfig.translate(KEY_SHOW_GHOST_BLOCKS);
        TRANSLATION_ALT_GHOST_RENDERER = ClientConfig.translate(KEY_ALT_GHOST_RENDERER);
        TRANSLATION_GHOST_RENDER_OPACITY = ClientConfig.translate(KEY_GHOST_RENDER_OPACITY);
        TRANSLATION_FANCY_HITBOXES = ClientConfig.translate(KEY_FANCY_HITBOXES);
        TRANSLATION_DETAILED_CULLING = ClientConfig.translate(KEY_DETAILED_CULLING);
        TRANSLATION_USE_DISCRETE_UV_STEPS = ClientConfig.translate(KEY_USE_DISCRETE_UV_STEPS);
        TRANSLATION_CON_TEX_MODE = ClientConfig.translate(KEY_CON_TEX_MODE);
        TRANSLATION_CAMO_MESSAGE_VERBOSITY = ClientConfig.translate(KEY_CAMO_MESSAGE_VERBOSITY);
        TRANSLATION_FORCE_AO_ON_GLOWING_BLOCKS = ClientConfig.translate(KEY_FORCE_AO_ON_GLOWING_BLOCKS);
        TRANSLATION_RENDER_ITEM_MODELS_WITH_CAMO = ClientConfig.translate(KEY_RENDER_ITEM_MODELS_WITH_CAMO);
        TRANSLATION_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI = ClientConfig.translate(KEY_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI);
        TRANSLATION_SOLID_FRAME_MODE = ClientConfig.translate(KEY_SOLID_FRAME_MODE);
        TRANSLATION_SHOW_BUTTON_PLATE_OVERLAY = ClientConfig.translate(KEY_SHOW_BUTTON_PLATE_OVERLAY);
        TRANSLATION_SHOW_SPECIAL_CUBE_OVERLAY = ClientConfig.translate(KEY_SHOW_SPECIAL_CUBE_OVERLAY);
        TRANSLATION_RENDER_CAMO_IN_JADE = ClientConfig.translate(KEY_RENDER_CAMO_IN_JADE);
        TRANSLATION_STATE_LOCK_MODE = ClientConfig.translate(KEY_STATE_LOCK_MODE);
        TRANSLATION_TOGGLE_WATERLOG_MODE = ClientConfig.translate(KEY_TOGGLE_WATERLOG_MODE);
        TRANSLATION_TOGGLE_Y_SLOPE_MODE = ClientConfig.translate(KEY_TOGGLE_Y_SLOPE_MODE);
        TRANSLATION_REINFORCEMENT_MODE = ClientConfig.translate(KEY_REINFORCEMENT_MODE);
        TRANSLATION_PRISM_OFFSET_MODE = ClientConfig.translate(KEY_PRISM_OFFSET_MODE);
        TRANSLATION_SPLIT_LINES_MODE = ClientConfig.translate(KEY_SPLIT_LINES_MODE);
        TRANSLATION_ONE_WAY_WINDOW_MODE = ClientConfig.translate(KEY_ONE_WAY_WINDOW_MODE);
        TRANSLATION_FRAME_BACKGROUND_MODE = ClientConfig.translate(KEY_FRAME_BACKGROUND_MODE);
        TRANSLATION_CAMO_ROTATION_MODE = ClientConfig.translate(KEY_CAMO_ROTATION_MODE);
        showGhostBlocks = false;
        altGhostRenderer = false;
        ghostRenderOpacity = 0;
        fancyHitboxes = false;
        detailedCulling = false;
        useDiscreteUVSteps = false;
        conTexMode = ConTexMode.DETAILED;
        camoMessageVerbosity = CamoMessageVerbosity.DEFAULT;
        forceAoOnGlowingBlocks = false;
        renderItemModelsWithCamo = false;
        showAllRecipePermutationsInEmi = false;
        solidFrameMode = SolidFrameMode.DEFAULT;
        showButtonPlateOverlay = false;
        showSpecialCubeOverlay = false;
        renderCamoInJade = false;
        stateLockMode = BlockInteractOverlay.Mode.DETAILED;
        toggleWaterlogMode = BlockInteractOverlay.Mode.DETAILED;
        toggleYSlopeMode = BlockInteractOverlay.Mode.DETAILED;
        reinforcementMode = BlockInteractOverlay.Mode.DETAILED;
        prismOffsetMode = BlockInteractOverlay.Mode.DETAILED;
        splitLineMode = BlockInteractOverlay.Mode.DETAILED;
        oneWayWindowMode = BlockInteractOverlay.Mode.DETAILED;
        frameBackgroundMode = BlockInteractOverlay.Mode.DETAILED;
        camoRotationMode = BlockInteractOverlay.Mode.DETAILED;
    }

    public static final class ViewImpl
    implements ExtConfigView.Client {
        @Override
        public boolean showGhostBlocks() {
            return showGhostBlocks;
        }

        @Override
        public boolean useAltGhostRenderer() {
            return altGhostRenderer;
        }

        @Override
        public int getGhostRenderOpacity() {
            return ghostRenderOpacity;
        }

        @Override
        public boolean useFancySelectionBoxes() {
            return fancyHitboxes;
        }

        @Override
        public boolean detailedCullingEnabled() {
            return detailedCulling;
        }

        @Override
        public boolean useDiscreteUVSteps() {
            return useDiscreteUVSteps;
        }

        @Override
        public ConTexMode getConTexMode() {
            return conTexMode;
        }

        @Override
        public CamoMessageVerbosity getCamoMessageVerbosity() {
            return camoMessageVerbosity;
        }

        @Override
        public boolean shouldForceAmbientOcclusionOnGlowingBlocks() {
            return forceAoOnGlowingBlocks;
        }

        @Override
        public boolean shouldRenderItemModelsWithCamo() {
            return renderItemModelsWithCamo;
        }

        @Override
        public boolean showAllRecipePermutationsInEmi() {
            return showAllRecipePermutationsInEmi;
        }

        @Override
        public SolidFrameMode getSolidFrameMode() {
            return solidFrameMode;
        }

        @Override
        public boolean showButtonPlateOverlay() {
            return showButtonPlateOverlay;
        }

        @Override
        public boolean showSpecialCubeOverlay() {
            return showSpecialCubeOverlay;
        }

        @Override
        public boolean shouldRenderCamoInJade() {
            return renderCamoInJade;
        }

        @Override
        public BlockInteractOverlay.Mode getStateLockMode() {
            return stateLockMode;
        }

        @Override
        public BlockInteractOverlay.Mode getToggleWaterlogMode() {
            return toggleWaterlogMode;
        }

        @Override
        public BlockInteractOverlay.Mode getToggleYSlopeMode() {
            return toggleYSlopeMode;
        }

        @Override
        public BlockInteractOverlay.Mode getReinforcementMode() {
            return reinforcementMode;
        }

        @Override
        public BlockInteractOverlay.Mode getPrismOffsetMode() {
            return prismOffsetMode;
        }

        @Override
        public BlockInteractOverlay.Mode getSplitLineMode() {
            return splitLineMode;
        }

        @Override
        public BlockInteractOverlay.Mode getOneWayWindowMode() {
            return oneWayWindowMode;
        }

        @Override
        public BlockInteractOverlay.Mode getFrameBackgroundMode() {
            return frameBackgroundMode;
        }

        @Override
        public BlockInteractOverlay.Mode getCamoRotationMode() {
            return camoRotationMode;
        }
    }
}

