/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.jei.FramedJeiPlugin;
import xfacthd.framedblocks.common.compat.jei.JeiCompat;
import xfacthd.framedblocks.common.compat.jei.RecipeTransferErrorTransferNotImplemented;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.menu.FramingSawMenu;
import xfacthd.framedblocks.common.menu.IFramingSawMenu;
import xfacthd.framedblocks.common.menu.PoweredFramingSawMenu;
import xfacthd.framedblocks.common.net.payload.ServerboundSelectFramingSawRecipePayload;

public abstract sealed class FramingSawTransferHandler<C extends AbstractContainerMenu>
implements IRecipeTransferHandler<C, FramingSawRecipe> {
    private final IRecipeTransferHandlerHelper transferHelper;
    private final IRecipeTransferInfo<C, FramingSawRecipe> transferInfo;
    private final IRecipeTransferHandler<C, FramingSawRecipe> wrappedHandler;

    private FramingSawTransferHandler(IRecipeTransferHandlerHelper transferHelper, Class<? extends C> menuClass, MenuType<C> menuType) {
        this.transferHelper = transferHelper;
        this.transferInfo = transferHelper.createBasicRecipeTransferInfo(menuClass, menuType, FramedJeiPlugin.FRAMING_SAW_RECIPE_TYPE, 0, 4, 5, 36);
        this.wrappedHandler = transferHelper.createUnregisteredRecipeTransferHandler(this.transferInfo);
    }

    public Class<? extends C> getContainerClass() {
        return this.transferInfo.getContainerClass();
    }

    public Optional<MenuType<C>> getMenuType() {
        return this.transferInfo.getMenuType();
    }

    public RecipeType<FramingSawRecipe> getRecipeType() {
        return this.transferInfo.getRecipeType();
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C menu, FramingSawRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        int idx = -1;
        List<RecipeHolder<FramingSawRecipe>> recipes = FramingSawRecipeCache.get(true).getRecipes();
        for (int i = 0; i < recipes.size(); ++i) {
            if (recipes.get(i).value() != recipe) continue;
            idx = i;
            break;
        }
        if (idx != -1 && ((IFramingSawMenu)menu).isValidRecipeIndex(idx)) {
            if (doTransfer && menu.clickMenuButton(player, idx)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSelectFramingSawRecipePayload(((AbstractContainerMenu)menu).containerId, idx), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return new RecipeTransferErrorTransferNotImplemented();
        }
        return this.transferHelper.createUserErrorWithTooltip(JeiCompat.MSG_INVALID_RECIPE);
    }

    public static final class PoweredFramingSaw
    extends FramingSawTransferHandler<PoweredFramingSawMenu> {
        public PoweredFramingSaw(IRecipeTransferHandlerHelper transferHelper) {
            super(transferHelper, PoweredFramingSawMenu.class, (MenuType)FBContent.MENU_TYPE_POWERED_FRAMING_SAW.get());
        }
    }

    public static final class FramingSaw
    extends FramingSawTransferHandler<FramingSawMenu> {
        public FramingSaw(IRecipeTransferHandlerHelper transferHelper) {
            super(transferHelper, FramingSawMenu.class, (MenuType)FBContent.MENU_TYPE_FRAMING_SAW.get());
        }
    }
}

