/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei;

import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramingSawWithEncoderScreen;
import xfacthd.framedblocks.client.screen.PoweredFramingSawScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.jei.FramingSawGhostIngredientHandler;
import xfacthd.framedblocks.common.compat.jei.FramingSawGuiContainerHandler;
import xfacthd.framedblocks.common.compat.jei.FramingSawRecipeCategory;
import xfacthd.framedblocks.common.compat.jei.FramingSawTransferHandler;
import xfacthd.framedblocks.common.compat.jei.JeiCompat;
import xfacthd.framedblocks.common.compat.jei.PoweredFramingSawGhostIngredientHandler;
import xfacthd.framedblocks.common.compat.jei.PoweredFramingSawGuiContainerHandler;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

@REIPluginCompatIgnore
@JeiPlugin
public final class FramedJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Utils.rl("jei_plugin");
    static final RecipeType<FramingSawRecipe> FRAMING_SAW_RECIPE_TYPE = new RecipeType(Utils.rl("framing_saw"), FramingSawRecipe.class);

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FramingSawRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(FRAMING_SAW_RECIPE_TYPE, FramingSawRecipeCache.get(true).getRecipes().stream().map(RecipeHolder::value).toList());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FramingSawTransferHandler.FramingSaw(registration.getTransferHelper()), FRAMING_SAW_RECIPE_TYPE);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new FramingSawTransferHandler.PoweredFramingSaw(registration.getTransferHelper()), FRAMING_SAW_RECIPE_TYPE);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)FBContent.BLOCK_FRAMING_SAW.value()), new RecipeType[]{FRAMING_SAW_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)FBContent.BLOCK_POWERED_FRAMING_SAW.value()), new RecipeType[]{FRAMING_SAW_RECIPE_TYPE});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(FramingSawWithEncoderScreen.class, (IGhostIngredientHandler)new FramingSawGhostIngredientHandler());
        registration.addGuiContainerHandler(FramingSawWithEncoderScreen.class, (IGuiContainerHandler)new FramingSawGuiContainerHandler());
        registration.addGhostIngredientHandler(PoweredFramingSawScreen.class, (IGhostIngredientHandler)new PoweredFramingSawGhostIngredientHandler());
        registration.addGuiContainerHandler(PoweredFramingSawScreen.class, (IGuiContainerHandler)new PoweredFramingSawGuiContainerHandler());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JeiCompat.GuardedAccess.acceptRuntime(jeiRuntime);
    }

    public void onRuntimeUnavailable() {
        JeiCompat.GuardedAccess.acceptRuntime(null);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

