/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.slab;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.blueprint.AuxBlueprintData;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.slab.FramedAdjustableDoubleBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedCollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.ICollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.data.component.AdjustableDoubleBlockData;

public class FramedAdjustableDoubleBlockEntity
extends FramedDoubleBlockEntity
implements ICollapsibleCopycatBlockEntity {
    private static final int MIN_PART_HEIGHT = 1;
    private static final int MAX_PART_HEIGHT = 15;
    public static final int CENTER_PART_HEIGHT = 8;
    private final ModelProperty<Integer> offsetProperty;
    private final OffsetPacker offsetPacker;
    private int firstHeight = 8;

    private FramedAdjustableDoubleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ModelProperty<Integer> offsetProperty, OffsetPacker offsetPacker) {
        super(type, pos, state);
        this.offsetProperty = offsetProperty;
        this.offsetPacker = offsetPacker;
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(this.getBlockState());
        Direction face = hit.getDirection();
        if (face == facing.getOpposite()) {
            return false;
        }
        if (face == facing) {
            return true;
        }
        int y = (int)(Utils.fractionInDir(hit.getLocation(), facing) * 16.0);
        return y > this.firstHeight;
    }

    public boolean handleDeform(Player player) {
        HitResult hit = player.pick(10.0, 1.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(this.getBlockState());
        Direction faceHit = blockHit.getDirection();
        if (faceHit.getAxis() != facing.getAxis()) {
            return false;
        }
        if (!this.level().isClientSide()) {
            boolean upwards = faceHit == facing.getOpposite() ^ player.isShiftKeyDown();
            boolean changed = false;
            if (!upwards && this.firstHeight > 1) {
                --this.firstHeight;
                changed = true;
            } else if (upwards && this.firstHeight < 15) {
                ++this.firstHeight;
                changed = true;
            }
            if (changed) {
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                this.setChangedWithoutSignalUpdate();
            }
        }
        return true;
    }

    @Override
    public int getFaceOffset(BlockState state, Direction side) {
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(this.getBlockState());
        Tuple<BlockState, BlockState> blockPair = this.getBlockPair();
        if (state == blockPair.getA() && side == facing) {
            return 16 - this.firstHeight;
        }
        if (state == blockPair.getB() && side == facing.getOpposite()) {
            return this.firstHeight;
        }
        return 0;
    }

    @Override
    public int getPackedOffsets(BlockState state) {
        Tuple<BlockState, BlockState> blockPair = this.getBlockPair();
        if (state == blockPair.getA()) {
            return this.offsetPacker.pack(this.getBlockState(), this.firstHeight, false);
        }
        if (state == blockPair.getB()) {
            return this.offsetPacker.pack(this.getBlockState(), this.firstHeight, true);
        }
        return 0;
    }

    @Override
    public ModelData getModelData(boolean includeCullInfo) {
        BlockState state = this.getBlockState();
        ModelData data = super.getModelData(includeCullInfo);
        ModelData dataLeft = Objects.requireNonNull((ModelData)data.get(DATA_LEFT)).derive().with(this.offsetProperty, (Object)this.offsetPacker.pack(state, this.firstHeight, false)).build();
        ModelData dataRight = Objects.requireNonNull((ModelData)data.get(DATA_RIGHT)).derive().with(this.offsetProperty, (Object)this.offsetPacker.pack(state, this.firstHeight, true)).build();
        return data.derive().with(DATA_LEFT, (Object)dataLeft).with(DATA_RIGHT, (Object)dataRight).build();
    }

    private static Direction getFacing(BlockState state) {
        return ((FramedAdjustableDoubleBlock)state.getBlock()).getFacing(state);
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(nbt, lookupProvider);
        nbt.putInt("first_height", this.firstHeight);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        boolean needUpdate = super.readFromDataPacket(nbt, lookupProvider);
        int height = nbt.getInt("first_height");
        if (height != this.firstHeight) {
            this.firstHeight = height;
            needUpdate = true;
            this.updateCulling(true, false);
        }
        return needUpdate;
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        nbt.putInt("first_height", this.firstHeight);
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        super.handleUpdateTag(nbt, provider);
        this.firstHeight = nbt.getInt("first_height");
    }

    @Override
    protected Optional<AuxBlueprintData<?>> collectAuxBlueprintData() {
        return Optional.of(new AdjustableDoubleBlockData(this.firstHeight));
    }

    @Override
    protected void applyAuxDataFromBlueprint(AuxBlueprintData<?> auxData) {
        if (auxData instanceof AdjustableDoubleBlockData) {
            AdjustableDoubleBlockData blockData = (AdjustableDoubleBlockData)auxData;
            this.firstHeight = blockData.firstHeight();
        }
    }

    @Override
    protected void collectMiscComponents(DataComponentMap.Builder builder) {
        builder.set(FBContent.DC_TYPE_ADJ_DOUBLE_BLOCK_DATA, (Object)new AdjustableDoubleBlockData(this.firstHeight));
    }

    @Override
    protected void applyMiscComponents(BlockEntity.DataComponentInput input) {
        AdjustableDoubleBlockData blockData = (AdjustableDoubleBlockData)input.get(FBContent.DC_TYPE_ADJ_DOUBLE_BLOCK_DATA);
        if (blockData != null) {
            this.firstHeight = blockData.firstHeight();
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putInt("first_height", this.firstHeight);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.firstHeight = nbt.getInt("first_height");
    }

    public static FramedAdjustableDoubleBlockEntity standard(BlockPos pos, BlockState state) {
        return new FramedAdjustableDoubleBlockEntity((BlockEntityType)FBContent.BE_TYPE_FRAMED_ADJ_DOUBLE_BLOCK.value(), pos, state, FramedCollapsibleBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsStandard);
    }

    public static FramedAdjustableDoubleBlockEntity copycat(BlockPos pos, BlockState state) {
        return new FramedAdjustableDoubleBlockEntity((BlockEntityType)FBContent.BE_TYPE_FRAMED_ADJ_DOUBLE_COPYCAT_BLOCK.value(), pos, state, FramedCollapsibleCopycatBlockEntity.OFFSETS, FramedAdjustableDoubleBlockEntity::getPackedOffsetsCopycat);
    }

    public static int getPackedOffsetsStandard(BlockState state, int firstHeight, boolean right) {
        if (!right) {
            firstHeight = 16 - firstHeight;
        }
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result |= firstHeight << i * 5;
        }
        return result;
    }

    public static int getPackedOffsetsCopycat(BlockState state, int firstHeight, boolean right) {
        Direction facing = FramedAdjustableDoubleBlockEntity.getFacing(state);
        if (right) {
            facing = facing.getOpposite();
        } else {
            firstHeight = 16 - firstHeight;
        }
        return firstHeight << facing.ordinal() * 4;
    }

    public static interface OffsetPacker {
        public int pack(BlockState var1, int var2, boolean var3);
    }
}

