/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.vertical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slope.FramedHalfSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedVerticalSlopedStairsBlock
extends FramedBlock {
    public FramedVerticalSlopedStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_SLOPED_STAIRS);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            Direction facing = ctx.getHorizontalDirection();
            state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing);
            Direction face = ctx.getClickedFace();
            HorizontalRotation rot = face == facing.getOpposite() ? HorizontalRotation.fromWallCorner(ctx.getClickLocation(), face) : HorizontalRotation.fromPerpendicularWallCorner(facing, face, ctx.getClickLocation());
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot));
        })).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        double frac;
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        Direction face = hit.getDirection();
        HorizontalRotation horRot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction rotDir = horRot.withFacing(facing);
        Direction rotDirTwo = horRot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        if (!Utils.isY(face) && (face == rotDir || face == rotDirTwo) && (frac = Utils.fractionInDir(hit.getLocation(), facing.getOpposite())) >= 0.5) {
            face = Direction.UP;
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(facing));
        }
        if (face.getAxis() == facing.getAxis()) {
            HorizontalRotation horRot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)horRot.rotate(rot)));
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        HorizontalRotation horRot;
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite());
        }
        horRot = (horRot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION))).isVertical() ? horRot.rotate(Rotation.CLOCKWISE_90) : horRot.rotate(Rotation.COUNTERCLOCKWISE_90);
        state = (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)horRot));
        return state;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape panelShape = CommonShapes.PANEL.get(Direction.NORTH);
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, FramedHalfSlopeBlock.SHAPES.get(new FramedHalfSlopeBlock.ShapeKey(false, true))));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, FramedHalfSlopeBlock.SHAPES.get(new FramedHalfSlopeBlock.ShapeKey(true, false))));
        VoxelShape shapeRight = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, FramedHalfSlopeBlock.SHAPES.get(new FramedHalfSlopeBlock.ShapeKey(false, false))));
        VoxelShape shapeLeft = ShapeUtils.orUnoptimized(panelShape, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, FramedHalfSlopeBlock.SHAPES.get(new FramedHalfSlopeBlock.ShapeKey(true, true))));
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(shapeUp, Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeDown, Direction.NORTH, shapes, HorizontalRotation.DOWN.ordinal() << 2);
        ShapeUtils.makeHorizontalRotations(shapeRight, Direction.NORTH, shapes, HorizontalRotation.RIGHT.ordinal() << 2);
        ShapeUtils.makeHorizontalRotations(shapeLeft, Direction.NORTH, shapes, HorizontalRotation.LEFT.ordinal() << 2);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

