/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.vertical;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedVerticalDoubleStairsBlock
extends FramedVerticalStairsBlock
implements IFramedDoubleBlock {
    public FramedVerticalDoubleStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        FramedUtils.removeProperty(builder, BlockStateProperties.WATERLOGGED);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsType type = (StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE));
        BlockState partTwo = switch (type) {
            default -> throw new MatchException(null, null);
            case StairsType.VERTICAL -> (BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite());
            case StairsType.TOP_FWD -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true));
            case StairsType.TOP_CCW -> (BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true));
            case StairsType.TOP_BOTH -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getOpposite())).setValue(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)StairsType.BOTTOM_BOTH));
            case StairsType.BOTTOM_FWD -> (BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getOpposite());
            case StairsType.BOTTOM_CCW -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getClockWise())).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true));
            case StairsType.BOTTOM_BOTH -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing.getOpposite())).setValue(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)StairsType.TOP_BOTH));
        };
        return new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue(PropertyHolder.STAIRS_TYPE, (Comparable)((Object)type))), (Object)partTwo);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsType type = (StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE));
        if (side == facing) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.TOP_CCW, StairsType.BOTTOM_CCW -> CamoGetter.FIRST;
                case StairsType.TOP_FWD, StairsType.TOP_BOTH -> CamoGetter.get(edge == facing.getCounterClockWise() || edge == Direction.DOWN, false);
                case StairsType.BOTTOM_FWD, StairsType.BOTTOM_BOTH -> CamoGetter.get(edge == facing.getCounterClockWise() || edge == Direction.UP, false);
            };
        }
        if (side == facing.getCounterClockWise()) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.TOP_FWD, StairsType.BOTTOM_FWD -> CamoGetter.FIRST;
                case StairsType.TOP_CCW, StairsType.TOP_BOTH -> CamoGetter.get(edge == facing || edge == Direction.DOWN, false);
                case StairsType.BOTTOM_CCW, StairsType.BOTTOM_BOTH -> CamoGetter.get(edge == facing || edge == Direction.UP, false);
            };
        }
        if (side == Direction.UP) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.BOTTOM_FWD, StairsType.BOTTOM_CCW, StairsType.BOTTOM_BOTH -> CamoGetter.get(edge == facing || edge == facing.getCounterClockWise(), false);
                case StairsType.TOP_CCW -> CamoGetter.get(edge == facing, edge == facing.getOpposite());
                case StairsType.TOP_FWD -> CamoGetter.get(edge == facing.getCounterClockWise(), edge == facing.getClockWise());
                case StairsType.TOP_BOTH -> CamoGetter.get(false, edge == facing.getOpposite() || edge == facing.getClockWise());
            };
        }
        if (side == Direction.DOWN) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.TOP_FWD, StairsType.TOP_CCW, StairsType.TOP_BOTH -> CamoGetter.get(edge == facing || edge == facing.getCounterClockWise(), false);
                case StairsType.BOTTOM_CCW -> CamoGetter.get(edge == facing, edge == facing.getOpposite());
                case StairsType.BOTTOM_FWD -> CamoGetter.get(edge == facing.getCounterClockWise(), edge == facing.getClockWise());
                case StairsType.BOTTOM_BOTH -> CamoGetter.get(false, edge == facing.getOpposite() || edge == facing.getClockWise());
            };
        }
        if (side == facing.getOpposite()) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.TOP_FWD, StairsType.BOTTOM_FWD -> CamoGetter.get(edge == facing.getCounterClockWise(), edge == facing.getClockWise());
                case StairsType.TOP_CCW, StairsType.TOP_BOTH -> CamoGetter.get(false, edge == facing.getClockWise() || edge == Direction.UP);
                case StairsType.BOTTOM_CCW, StairsType.BOTTOM_BOTH -> CamoGetter.get(false, edge == facing.getClockWise() || edge == Direction.DOWN);
            };
        }
        if (side == facing.getClockWise()) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case StairsType.VERTICAL, StairsType.TOP_CCW, StairsType.BOTTOM_CCW -> CamoGetter.get(edge == facing, edge == facing.getOpposite());
                case StairsType.TOP_FWD, StairsType.TOP_BOTH -> CamoGetter.get(false, edge == facing.getOpposite() || edge == Direction.UP);
                case StairsType.BOTTOM_FWD, StairsType.BOTTOM_BOTH -> CamoGetter.get(false, edge == facing.getOpposite() || edge == Direction.DOWN);
            };
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsType type = (StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE));
        if (side == facing && (type == StairsType.VERTICAL || type == StairsType.TOP_CCW || type == StairsType.BOTTOM_CCW)) {
            return SolidityCheck.FIRST;
        }
        if (side == facing.getCounterClockWise() && (type == StairsType.VERTICAL || type == StairsType.TOP_FWD || type == StairsType.BOTTOM_FWD)) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.BOTH;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }
}

