/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.vertical;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedVerticalDividedStairsBlock
extends FramedVerticalStairsBlock
implements IFramedDoubleBlock {
    public FramedVerticalDividedStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        return switch ((StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE))) {
            default -> throw new MatchException(null, null);
            case StairsType.VERTICAL -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            case StairsType.TOP_FWD -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            case StairsType.TOP_CCW -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            case StairsType.TOP_BOTH -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            case StairsType.BOTTOM_FWD -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            case StairsType.BOTTOM_CCW -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
            case StairsType.BOTTOM_BOTH -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
        };
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.SECOND;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsType type = (StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE));
        if (side == Direction.DOWN && edge == facing || side == facing && edge == Direction.DOWN) {
            return !type.isBottom() || type == StairsType.BOTTOM_CCW ? CamoGetter.FIRST : CamoGetter.NONE;
        }
        if (side == Direction.UP && edge == facing || side == facing && edge == Direction.UP) {
            return !type.isTop() || type == StairsType.TOP_CCW ? CamoGetter.SECOND : CamoGetter.NONE;
        }
        Direction facingCcw = facing.getCounterClockWise();
        if (side == Direction.DOWN && edge == facingCcw || side == facingCcw && edge == Direction.DOWN) {
            return !type.isBottom() || type == StairsType.BOTTOM_FWD ? CamoGetter.FIRST : CamoGetter.NONE;
        }
        if (side == Direction.UP && edge == facingCcw || side == facingCcw && edge == Direction.UP) {
            return !type.isTop() || type == StairsType.TOP_FWD ? CamoGetter.SECOND : CamoGetter.NONE;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsType type = (StairsType)((Object)state.getValue(PropertyHolder.STAIRS_TYPE));
        if (side == facing && !type.isForward()) {
            return SolidityCheck.BOTH;
        }
        if (side == facing.getCounterClockWise() && !type.isCounterClockwise()) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }
}

