/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.standard;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedSlicedStairsPanelBlock
extends FramedStairsBlock
implements IFramedDoubleBlock {
    public FramedSlicedStairsPanelBlock() {
        super(BlockType.FRAMED_SLICED_STAIRS_PANEL);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean top = state.getValue((Property)HALF) == Half.TOP;
        return switch ((StairsShape)state.getValue((Property)SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
            case StairsShape.INNER_LEFT -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
            case StairsShape.INNER_RIGHT -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
            case StairsShape.OUTER_LEFT -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir)), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
            case StairsShape.OUTER_RIGHT -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getClockWise())), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction dirTwo;
        Direction dir = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        boolean top = state.getValue((Property)HALF) == Half.TOP;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == dir && shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return SolidityCheck.FIRST;
        }
        if (side == dir.getCounterClockWise() && shape == StairsShape.INNER_LEFT) {
            return SolidityCheck.FIRST;
        }
        if (side == dir.getClockWise() && shape == StairsShape.INNER_RIGHT) {
            return SolidityCheck.FIRST;
        }
        if (side == dirTwo) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean top = state.getValue((Property)HALF) == Half.TOP;
        Direction dirTwo = top ? Direction.UP : Direction.DOWN;
        return switch ((StairsShape)state.getValue((Property)SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> {
                if (side == dir || side.getAxis() != dir.getAxis() && edge == dir) {
                    yield CamoGetter.FIRST;
                }
                if (side == dirTwo && edge == dir.getOpposite()) {
                    yield CamoGetter.SECOND;
                }
                if (side == dir.getOpposite() && edge == dirTwo) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.INNER_LEFT -> {
                if (side == dir || side == dir.getCounterClockWise()) {
                    yield CamoGetter.FIRST;
                }
                if (Utils.isY(side) && (edge == dir || edge == dir.getCounterClockWise())) {
                    yield CamoGetter.FIRST;
                }
                if (side == dir.getClockWise() && edge == dir || side == dir.getOpposite() && edge == dir.getCounterClockWise()) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.INNER_RIGHT -> {
                if (side == dir || side == dir.getClockWise()) {
                    yield CamoGetter.FIRST;
                }
                if (Utils.isY(side) && (edge == dir || edge == dir.getClockWise())) {
                    yield CamoGetter.FIRST;
                }
                if (side == dir.getCounterClockWise() && edge == dir || side == dir.getOpposite() && edge == dir.getClockWise()) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.OUTER_LEFT -> {
                if (side == dir && edge == dir.getCounterClockWise() || side == dir.getCounterClockWise() && edge == dir) {
                    yield CamoGetter.FIRST;
                }
                if (side == dirTwo && (edge == dir.getClockWise() || edge == dir.getOpposite())) {
                    yield CamoGetter.SECOND;
                }
                if ((side == dir.getClockWise() || side == dir.getOpposite()) && edge == dirTwo) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.OUTER_RIGHT -> side == dir && edge == dir.getClockWise() || side == dir.getClockWise() && edge == dir ? CamoGetter.FIRST : (side == dirTwo && (edge == dir.getCounterClockWise() || edge == dir.getOpposite()) ? CamoGetter.SECOND : ((side == dir.getCounterClockWise() || side == dir.getOpposite()) && edge == dirTwo ? CamoGetter.SECOND : CamoGetter.NONE));
        };
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

