/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.standard;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLadderBlock
extends FramedBlock {
    private static final VoxelShape SHAPE_NORTH = FramedLadderBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape COLLISION_SHAPE_NORTH = FramedLadderBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final ShapeCache<Direction> SHAPES = ShapeCache.createEnum(Direction.class, map -> ShapeUtils.makeHorizontalRotations(SHAPE_NORTH, Direction.NORTH, map));
    private static final ShapeCache<Direction> COLLISION_SHAPES = ShapeCache.createEnum(Direction.class, map -> ShapeUtils.makeHorizontalRotations(COLLISION_SHAPE_NORTH, Direction.NORTH, map));

    public FramedLadderBlock() {
        super(BlockType.FRAMED_LADDER);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withWater()).build();
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPES.get((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public boolean makesOpenTrapdoorAboveClimbable(BlockState state, LevelReader level, BlockPos pos, BlockState trapdoorState) {
        return state.getValue((Property)FramedProperties.FACING_HOR) == ((Direction)trapdoorState.getValue((Property)TrapDoorBlock.FACING)).getOpposite();
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

