/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.standard;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedDoubleStairsBlock
extends FramedStairsBlock
implements IFramedDoubleBlock {
    public FramedDoubleStairsBlock() {
        super(BlockType.FRAMED_DOUBLE_STAIRS);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        FramedUtils.removeProperty(builder, WATERLOGGED);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Direction side = ctx.getClickedFace();
        Half half = switch (side) {
            case Direction.UP -> Half.BOTTOM;
            case Direction.DOWN -> Half.TOP;
            default -> Utils.fractionInDir(ctx.getClickLocation(), Direction.UP) > 0.5 ? Half.TOP : Half.BOTTOM;
        };
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection())).setValue((Property)HALF, (Comparable)half);
        return (BlockState)state.setValue((Property)SHAPE, (Comparable)FramedDoubleStairsBlock.getStairsShape((BlockState)state, (BlockGetter)ctx.getLevel(), (BlockPos)pos));
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction side, BlockState adjState, LevelAccessor level, BlockPos pos, BlockPos adjPos) {
        BlockState newState = this.updateShapeLockable(state, level, pos, () -> !Utils.isY(side) ? (BlockState)state.setValue((Property)SHAPE, (Comparable)FramedDoubleStairsBlock.getStairsShape((BlockState)state, (BlockGetter)level, (BlockPos)pos)) : state);
        if (newState == state) {
            this.updateCulling((LevelReader)level, pos);
        }
        return newState;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.isIntangible(state, level, pos, ctx) ? Shapes.empty() : Shapes.block();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        return false;
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor level, BlockPos pos, BlockState state) {
        return ItemStack.EMPTY;
    }

    protected FluidState getFluidState(BlockState state) {
        return Fluids.EMPTY.defaultFluidState();
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        boolean top = state.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        BlockState partTwo = switch (shape) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.INNER_LEFT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.INNER_RIGHT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.OUTER_LEFT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
            case StairsShape.OUTER_RIGHT -> (BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top));
        };
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_STAIRS.value()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)BlockStateProperties.STAIRS_SHAPE, (Comparable)shape)).setValue((Property)BlockStateProperties.HALF, (Comparable)(top ? Half.TOP : Half.BOTTOM))), (Object)partTwo);
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        if (state.getValue((Property)BlockStateProperties.HALF) == Half.TOP) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean top = state.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        Direction dirTwo = top ? Direction.UP : Direction.DOWN;
        return switch ((StairsShape)state.getValue((Property)SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> {
                if (side == facing || side == dirTwo) {
                    yield CamoGetter.FIRST;
                }
                if (side == facing.getOpposite()) {
                    if (edge == dirTwo) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == dirTwo.getOpposite()) {
                        yield CamoGetter.SECOND;
                    }
                } else if (side == dirTwo.getOpposite()) {
                    if (edge == facing) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.getOpposite()) {
                        yield CamoGetter.SECOND;
                    }
                } else if (side.getAxis() == facing.getClockWise().getAxis() && (edge == facing || edge == dirTwo)) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.INNER_LEFT -> {
                if (side == facing || side == facing.getCounterClockWise() || side == dirTwo) {
                    yield CamoGetter.FIRST;
                }
                if (side == dirTwo.getOpposite()) {
                    if (edge == facing || edge == facing.getCounterClockWise()) {
                        yield CamoGetter.FIRST;
                    }
                } else if (side == facing.getOpposite()) {
                    if (edge == facing.getCounterClockWise() || edge == dirTwo) {
                        yield CamoGetter.FIRST;
                    }
                } else if (side == facing.getClockWise() && (edge == facing || edge == dirTwo)) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.INNER_RIGHT -> {
                if (side == facing || side == facing.getClockWise() || side == dirTwo) {
                    yield CamoGetter.FIRST;
                }
                if (side == dirTwo.getOpposite()) {
                    if (edge == facing || edge == facing.getClockWise()) {
                        yield CamoGetter.FIRST;
                    }
                } else if (side == facing.getOpposite()) {
                    if (edge == facing.getClockWise() || edge == dirTwo) {
                        yield CamoGetter.FIRST;
                    }
                } else if (side == facing.getCounterClockWise() && (edge == facing || edge == dirTwo)) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.OUTER_LEFT -> {
                if (side == dirTwo || side != dirTwo.getOpposite() && edge == dirTwo) {
                    yield CamoGetter.FIRST;
                }
                if (side == facing && edge == facing.getCounterClockWise()) {
                    yield CamoGetter.FIRST;
                }
                if (side == dirTwo.getOpposite() && (edge == facing.getOpposite() || edge == facing.getClockWise())) {
                    yield CamoGetter.SECOND;
                }
                if ((side == facing.getOpposite() || side == facing.getClockWise()) && edge == dirTwo.getOpposite()) {
                    yield CamoGetter.SECOND;
                }
                if (side == facing.getCounterClockWise() && edge == facing) {
                    yield CamoGetter.FIRST;
                }
                yield CamoGetter.NONE;
            }
            case StairsShape.OUTER_RIGHT -> side == dirTwo || side != dirTwo.getOpposite() && edge == dirTwo ? CamoGetter.FIRST : (side == facing && edge == facing.getClockWise() ? CamoGetter.FIRST : (side == dirTwo.getOpposite() && (edge == facing.getOpposite() || edge == facing.getCounterClockWise()) ? CamoGetter.SECOND : ((side == facing.getOpposite() || side == facing.getCounterClockWise()) && edge == dirTwo.getOpposite() ? CamoGetter.SECOND : (side == facing.getClockWise() && edge == facing ? CamoGetter.FIRST : CamoGetter.NONE))));
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction dirTwo;
        Direction facing = (Direction)state.getValue((Property)FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        boolean top = state.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == facing && shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return SolidityCheck.FIRST;
        }
        if (side == dirTwo) {
            return SolidityCheck.FIRST;
        }
        if (shape == StairsShape.INNER_LEFT && side == facing.getCounterClockWise()) {
            return SolidityCheck.FIRST;
        }
        if (shape == StairsShape.INNER_RIGHT && side == facing.getClockWise()) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.BOTH;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

