/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs.standard;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedDoubleBlock;
import xfacthd.framedblocks.common.block.stairs.standard.FramedStairsBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.FramedDoubleBlockRenderProperties;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;

public class FramedDividedStairsBlock
extends FramedStairsBlock
implements IFramedDoubleBlock {
    public FramedDividedStairsBlock() {
        super(BlockType.FRAMED_DIVIDED_STAIRS);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean top = state.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        return switch ((StairsShape)state.getValue((Property)SHAPE)) {
            default -> throw new MatchException(null, null);
            case StairsShape.STRAIGHT -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))));
            case StairsShape.INNER_LEFT -> new Tuple((Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getCounterClockWise())), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))));
            case StairsShape.INNER_RIGHT -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((Block)FBContent.BLOCK_FRAMED_PANEL.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getClockWise())));
            case StairsShape.OUTER_LEFT -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))));
            case StairsShape.OUTER_RIGHT -> new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getCounterClockWise())).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value()).defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))));
        };
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction dirTwo;
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        boolean top = state.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == facing) {
            if (edge == facing.getCounterClockWise() && shape != StairsShape.OUTER_RIGHT) {
                return CamoGetter.FIRST;
            }
            if (edge == facing.getClockWise() && shape != StairsShape.OUTER_LEFT) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        if (side == dirTwo) {
            if (edge == facing.getCounterClockWise()) {
                return CamoGetter.FIRST;
            }
            if (edge == facing.getClockWise()) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        if (side == dirTwo.getOpposite() || side == facing.getOpposite()) {
            if (shape == StairsShape.INNER_LEFT && edge == facing.getCounterClockWise()) {
                return CamoGetter.FIRST;
            }
            if (shape == StairsShape.INNER_RIGHT && edge == facing.getClockWise()) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        if (side == facing.getCounterClockWise()) {
            if (shape == StairsShape.INNER_LEFT) {
                return CamoGetter.FIRST;
            }
            if (shape != StairsShape.OUTER_RIGHT && (edge == facing || edge == dirTwo)) {
                return CamoGetter.FIRST;
            }
            return CamoGetter.NONE;
        }
        if (side == facing.getClockWise()) {
            if (shape == StairsShape.INNER_RIGHT) {
                return CamoGetter.SECOND;
            }
            if (shape != StairsShape.OUTER_LEFT && (edge == facing || edge == dirTwo)) {
                return CamoGetter.SECOND;
            }
            return CamoGetter.NONE;
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction dirTwo;
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        boolean top = state.getValue((Property)BlockStateProperties.HALF) == Half.TOP;
        Direction direction = dirTwo = top ? Direction.UP : Direction.DOWN;
        if (side == facing && shape != StairsShape.OUTER_LEFT && shape != StairsShape.OUTER_RIGHT) {
            return SolidityCheck.BOTH;
        }
        if (side == dirTwo) {
            return SolidityCheck.BOTH;
        }
        if (shape == StairsShape.INNER_LEFT && side == facing.getCounterClockWise()) {
            return SolidityCheck.FIRST;
        }
        if (shape == StairsShape.INNER_RIGHT && side == facing.getClockWise()) {
            return SolidityCheck.FIRST;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleBlockEntity(pos, state);
    }

    @Override
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(FramedDoubleBlockRenderProperties.INSTANCE);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

