/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeslab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlopeSlabBlock
extends FramedBlock {
    public static final ShapeCache<SlopeSlabShape> SHAPES = ShapeCache.create(map -> {
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedSlopeSlabBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopeSlabBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)15.0), FramedSlopeSlabBlock.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)4.0, (double)12.0), FramedSlopeSlabBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0), FramedSlopeSlabBlock.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)7.75, (double)4.0), FramedSlopeSlabBlock.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)0.5));
        map.put(SlopeSlabShape.BOTTOM_BOTTOM_HALF, shapeBottom);
        map.put(SlopeSlabShape.BOTTOM_TOP_HALF, shapeBottom.move(0.0, 0.5, 0.0));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedSlopeSlabBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)0.5), FramedSlopeSlabBlock.box((double)0.0, (double)0.25, (double)0.0, (double)16.0, (double)2.0, (double)4.0), FramedSlopeSlabBlock.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)4.0, (double)8.0), FramedSlopeSlabBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)12.0), FramedSlopeSlabBlock.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.0, (double)15.0), FramedSlopeSlabBlock.box((double)0.0, (double)7.5, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
        map.put(SlopeSlabShape.TOP_BOTTOM_HALF, shapeTop);
        map.put(SlopeSlabShape.TOP_TOP_HALF, shapeTop.move(0.0, 0.5, 0.0));
    });

    public FramedSlopeSlabBlock() {
        super(BlockType.FRAMED_SLOPE_SLAB);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)PropertyHolder.TOP_HALF, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.TOP_HALF, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetOrHorizontalFacing()).withTop(PropertyHolder.TOP_HALF)).withCustom((state, modCtx) -> (BlockState)state.setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(ctx.getPlayer() != null && ctx.getPlayer().isShiftKeyDown())))).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face) || face == dir.getOpposite()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)PropertyHolder.TOP_HALF);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottomBottomHalf = SHAPES.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
        VoxelShape shapeBottomTopHalf = SHAPES.get(SlopeSlabShape.BOTTOM_TOP_HALF);
        VoxelShape shapeTopBottomHalf = SHAPES.get(SlopeSlabShape.TOP_BOTTOM_HALF);
        VoxelShape shapeTopTopHalf = SHAPES.get(SlopeSlabShape.TOP_TOP_HALF);
        int maskTop = 4;
        int maskTopHalf = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        ShapeUtils.makeHorizontalRotations(shapeBottomBottomHalf, Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeBottomTopHalf, Direction.NORTH, shapes, maskTopHalf);
        ShapeUtils.makeHorizontalRotations(shapeTopBottomHalf, Direction.NORTH, shapes, maskTop);
        ShapeUtils.makeHorizontalRotations(shapeTopTopHalf, Direction.NORTH, shapes, maskTop | maskTopHalf);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.getValue((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int topHalf = (Boolean)state.getValue((Property)PropertyHolder.TOP_HALF) != false ? maskTopHalf : 0;
            int idx = dir.get2DDataValue() | top | topHalf;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public record ShapeKey(boolean top, boolean topHalf) {
    }
}

