/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedExtendedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedExtendedCornerSlopePanelWallBlock
extends FramedBlock {
    private final Holder<Block> nonWallBlock;
    public static ShapeCache<HorizontalRotation> SHAPES = ShapeCache.createEnum(HorizontalRotation.class, map -> {
        VoxelShape shapeOneUpLeft = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT));
        VoxelShape shapeOneDownRight = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT));
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> shapeOneUpLeft;
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> shapeOneDownRight;
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
            };
            map.put(rot, ShapeUtils.andUnoptimized(shapeOne, shapeTwo));
        }
    });
    private static final ShapeCache<ShapeKey> FINAL_SHAPES = ShapeCache.create(map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            ShapeUtils.makeHorizontalRotations(SHAPES.get(rot), Direction.NORTH, map, rot, ShapeKey::new);
        }
    });
    public static final ShapeCache<HorizontalRotation> INNER_SHAPES = ShapeCache.createEnum(HorizontalRotation.class, map -> {
        VoxelShape shapeOneUpLeft = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.RIGHT));
        VoxelShape shapeOneDownRight = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, FramedExtendedSlopePanelBlock.SHAPES.get(HorizontalRotation.LEFT));
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> shapeOneUpLeft;
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> shapeOneDownRight;
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.FALSE);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedElevatedSlopeSlabBlock.SHAPES.get(Boolean.TRUE);
            };
            map.put(rot, ShapeUtils.orUnoptimized(shapeOne, shapeTwo));
        }
    });
    private static final ShapeCache<ShapeKey> FINAL_INNER_SHAPES = ShapeCache.create(map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            ShapeUtils.makeHorizontalRotations(INNER_SHAPES.get(rot), Direction.NORTH, map, rot, ShapeKey::new);
        }
    });

    public FramedExtendedCornerSlopePanelWallBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
        this.nonWallBlock = switch (type) {
            case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL;
            case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL;
            default -> throw new IllegalArgumentException("Unknown corner slope panel type: " + String.valueOf(type));
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this, ctx, this.getBlockType() == BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        switch (this.getBlockType()) {
            case FRAMED_EXT_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir.getOpposite() && side != perpRotDir.getOpposite()) break;
                side = dir;
                break;
            }
            case FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir && side != perpRotDir) break;
                Vec3 hitVec = hit.getLocation();
                double paralell = Utils.fractionInDir(hitVec, dir);
                double perp = Utils.fractionInDir(hitVec, side == rotDir ? perpRotDir : rotDir) - 0.5;
                if (!(perp * 2.0 > paralell)) break;
                side = dir;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (face.getAxis() == dir.getAxis()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.getValue((Property)FramedProperties.FACING_HOR), rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return ((IFramedBlock)this.nonWallBlock.value()).getJadeRenderState(state);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            builder.put((Object)state, (Object)FINAL_SHAPES.get(new ShapeKey(dir, rot)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            builder.put((Object)state, (Object)FINAL_INNER_SHAPES.get(new ShapeKey(dir, rot)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private record ShapeKey(Direction dir, HorizontalRotation rot) {
    }
}

