/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedExtendedCornerSlopePanelWallBlock;
import xfacthd.framedblocks.common.block.slopeslab.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.slopeslab.SlopeSlabShape;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedCornerSlopePanelWallBlock
extends FramedBlock {
    private final boolean large;
    private final Holder<Block> nonWallBlock;
    public static final ShapeCache<HorizontalRotation> SHAPES_LARGE = ShapeCache.createEnum(HorizontalRotation.class, map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            map.put(rot, Shapes.joinUnoptimized((VoxelShape)FramedExtendedCornerSlopePanelWallBlock.SHAPES.get(rot), (VoxelShape)rot.getCornerShape(), (BooleanOp)BooleanOp.NOT_SAME));
        }
    });
    public static final ShapeCache<HorizontalRotation> SHAPES_SMALL_INNER = ShapeCache.createEnum(HorizontalRotation.class, map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            map.put(rot, ShapeUtils.andUnoptimized(FramedExtendedCornerSlopePanelWallBlock.INNER_SHAPES.get(rot), rot.getCornerShape()));
        }
    });

    public FramedCornerSlopePanelWallBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(true)));
        this.large = type == BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W || type == BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W;
        this.nonWallBlock = switch (type) {
            case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL;
            case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL;
            case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL;
            case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL;
            default -> throw new IllegalArgumentException("Unknown corner slope panel type: " + String.valueOf(type));
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelWallBlock.getStateForPlacement(this, ctx, this.large);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext ctx, boolean invert) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(block, ctx).withHorizontalTargetFacing()).withCornerRotation(!invert).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        switch (this.getBlockType()) {
            case FRAMED_SMALL_CORNER_SLOPE_PANEL_W: 
            case FRAMED_LARGE_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir.getOpposite() && side != perpRotDir.getOpposite()) break;
                side = dir;
                break;
            }
            case FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W: 
            case FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W: {
                if (side != rotDir && side != perpRotDir) break;
                Vec3 hitVec = hit.getLocation();
                double paralell = Utils.fractionInDir(hitVec, dir);
                double perp = Utils.fractionInDir(hitVec, side == rotDir ? perpRotDir : rotDir) - 0.5;
                if (!(perp * 2.0 > paralell)) break;
                side = dir;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (face.getAxis() == dir.getAxis()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, (Direction)state.getValue((Property)FramedProperties.FACING_HOR), rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedCornerSlopePanelWallBlock.mirrorCornerPanel(state, mirror);
    }

    public static BlockState mirrorCornerPanel(BlockState state, Mirror mirror) {
        HorizontalRotation rot;
        if (mirror == Mirror.NONE) {
            return state;
        }
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        rot = rot.rotate((rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION))).isVertical() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
        return (BlockState)newState.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot));
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return ((IFramedBlock)this.nonWallBlock.value()).getJadeRenderState(state);
    }

    public static ShapeProvider generateSmallShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeOneUpLeft = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.LEFT_BACK));
        VoxelShape shapeOneDownRight = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.RIGHT_BACK));
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> shapeOneUpLeft;
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> shapeOneDownRight;
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.TOP_TOP_HALF);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
            };
            VoxelShape preShape = ShapeUtils.andUnoptimized(shapeOne, shapeTwo);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = SHAPES_LARGE.get(rot);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateSmallInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = SHAPES_SMALL_INNER.get(rot);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeOneUpLeft = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.RIGHT_BACK));
        VoxelShape shapeOneDownRight = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.LEFT_BACK));
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shapeOne = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.LEFT -> shapeOneUpLeft;
                case HorizontalRotation.DOWN, HorizontalRotation.RIGHT -> shapeOneDownRight;
            };
            VoxelShape shapeTwo = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP, HorizontalRotation.RIGHT -> FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.BOTTOM_BOTTOM_HALF);
                case HorizontalRotation.LEFT, HorizontalRotation.DOWN -> FramedSlopeSlabBlock.SHAPES.get(SlopeSlabShape.TOP_TOP_HALF);
            };
            VoxelShape preShape = ShapeUtils.orUnoptimized(shapeOne, shapeTwo);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

