/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerSlopePanelShape;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedCornerSlopePanelBlock
extends FramedBlock {
    private final boolean inner;
    private final boolean frontEdge;
    public static final ShapeCache<CornerSlopePanelShape> SHAPES = ShapeCache.createEnum(CornerSlopePanelShape.class, map -> {
        VoxelShape panelShapeBottom = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.UP_BACK);
        map.put(CornerSlopePanelShape.SMALL_BOTTOM, ShapeUtils.andUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeBottom)));
        VoxelShape panelShapeTop = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.DOWN_BACK);
        map.put(CornerSlopePanelShape.SMALL_TOP, ShapeUtils.andUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeTop)));
        VoxelShape panelShapeBot = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.UP_FRONT);
        VoxelShape panelShapeBotRot = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeBot);
        map.put(CornerSlopePanelShape.LARGE_BOTTOM, ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeBot, panelShapeBotRot), ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeBot, FramedCornerSlopePanelBlock.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)), ShapeUtils.andUnoptimized(panelShapeBotRot, FramedCornerSlopePanelBlock.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)))));
        panelShapeTop = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.DOWN_FRONT);
        VoxelShape panelShapeTopRot = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeTop);
        map.put(CornerSlopePanelShape.LARGE_TOP, ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeTop, panelShapeTopRot), ShapeUtils.orUnoptimized(ShapeUtils.andUnoptimized(panelShapeTop, FramedCornerSlopePanelBlock.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0)), ShapeUtils.andUnoptimized(panelShapeTopRot, FramedCornerSlopePanelBlock.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)))));
        panelShapeBottom = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.UP_FRONT);
        map.put(CornerSlopePanelShape.SMALL_INNER_BOTTOM, ShapeUtils.andUnoptimized(FramedCornerSlopePanelBlock.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), ShapeUtils.orUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeBottom))));
        panelShapeTop = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.DOWN_FRONT);
        map.put(CornerSlopePanelShape.SMALL_INNER_TOP, ShapeUtils.andUnoptimized(FramedCornerSlopePanelBlock.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), ShapeUtils.orUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeTop))));
        panelShapeBottom = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.UP_BACK);
        map.put(CornerSlopePanelShape.LARGE_INNER_BOTTOM, ShapeUtils.orUnoptimized(panelShapeBottom, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeBottom)));
        panelShapeTop = FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.DOWN_BACK);
        map.put(CornerSlopePanelShape.LARGE_INNER_TOP, ShapeUtils.orUnoptimized(panelShapeTop, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, panelShapeTop)));
    });

    public FramedCornerSlopePanelBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
        this.inner = type == BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL || type == BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL;
        this.frontEdge = type == BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL || type == BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelBlock.getStateForPlacement(this, ctx, this.inner, this.frontEdge);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext ctx, boolean invert, boolean invertFracDir) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(block, ctx).withCustom((state, modCtx) -> {
            Direction dir = modCtx.getHorizontalDirection();
            if (invert) {
                dir = dir.getOpposite();
            }
            Direction fracDir = modCtx.getHorizontalDirection();
            if (invertFracDir) {
                fracDir = fracDir.getOpposite();
            }
            if (Utils.fractionInDir(modCtx.getClickLocation(), fracDir.getClockWise()) > 0.5) {
                dir = dir.getClockWise();
            }
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        })).withTop()).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        switch (this.getBlockType()) {
            case FRAMED_SMALL_CORNER_SLOPE_PANEL: 
            case FRAMED_LARGE_CORNER_SLOPE_PANEL: {
                if (side != dir.getOpposite() && side != dir.getClockWise()) break;
                side = Direction.UP;
                break;
            }
            case FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL: 
            case FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL: {
                if (side != dir && side != dir.getCounterClockWise()) break;
                boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
                Vec3 hitVec = hit.getLocation();
                double y = Utils.fractionInDir(hitVec, top ? Direction.UP : Direction.DOWN);
                double xz = Utils.fractionInDir(hitVec, side == dir ? dir.getCounterClockWise() : dir) - 0.5;
                if (!(xz * 2.0 > y)) break;
                side = Direction.UP;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        return (BlockState)state.cycle((Property)FramedProperties.TOP);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockItem createBlockItem() {
        Block other = switch (this.getBlockType()) {
            case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL_WALL.value();
            case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL.value();
            case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL.value();
            case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_WALL.value();
            default -> throw new IllegalStateException("Unexpected type: " + String.valueOf(this.getBlockType()));
        };
        return new VerticalAndWallBlockItem(this, other, new Item.Properties());
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)(this.inner ? Direction.EAST : Direction.WEST));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateSmallShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.SMALL_BOTTOM), SHAPES.get(CornerSlopePanelShape.SMALL_TOP), Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.LARGE_BOTTOM), SHAPES.get(CornerSlopePanelShape.LARGE_TOP), Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateSmallInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.SMALL_INNER_BOTTOM), SHAPES.get(CornerSlopePanelShape.SMALL_INNER_TOP), Direction.SOUTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLargeInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(SHAPES.get(CornerSlopePanelShape.LARGE_INNER_BOTTOM), SHAPES.get(CornerSlopePanelShape.LARGE_INNER_TOP), Direction.SOUTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

