/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedSlopePanelBlock
extends FramedBlock {
    public static final ShapeCache<SlopePanelShape> SHAPES = ShapeCache.create(map -> {
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)8.0), FramedSlopePanelBlock.box((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)7.75), FramedSlopePanelBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)6.0), FramedSlopePanelBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), FramedSlopePanelBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), FramedSlopePanelBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5));
        map.put(SlopePanelShape.UP_BACK, shapeUp);
        map.put(SlopePanelShape.UP_FRONT, shapeUp.move(0.0, 0.0, 0.5));
        VoxelShape shapeRight = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)8.0), FramedSlopePanelBlock.box((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.75), FramedSlopePanelBlock.box((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.box((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.box((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5));
        map.put(SlopePanelShape.RIGHT_BACK, shapeRight);
        map.put(SlopePanelShape.RIGHT_FRONT, shapeRight.move(0.0, 0.0, 0.5));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopePanelBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)7.75), FramedSlopePanelBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), FramedSlopePanelBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), FramedSlopePanelBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)4.0, (double)2.0), FramedSlopePanelBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)0.5));
        map.put(SlopePanelShape.DOWN_BACK, shapeDown);
        map.put(SlopePanelShape.DOWN_FRONT, shapeDown.move(0.0, 0.0, 0.5));
        VoxelShape shapeLeft = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopePanelBlock.box((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)7.75), FramedSlopePanelBlock.box((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.box((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.box((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)0.5));
        map.put(SlopePanelShape.LEFT_BACK, shapeLeft);
        map.put(SlopePanelShape.LEFT_FRONT, shapeLeft.move(0.0, 0.0, 0.5));
    });

    public FramedSlopePanelBlock() {
        super(BlockType.FRAMED_SLOPE_PANEL);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedSlopePanelBlock.getStateForPlacement(this, context);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext context) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(block, context).withHorizontalFacing()).withCrossOrSideRotation().withFront().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        if (face.getAxis() == dir.getAxis() || face == rotation.withFacing(dir)) {
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)PropertyHolder.FRONT);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction side = Direction.UP;
        if (state.getValue(PropertyHolder.ROTATION) == HorizontalRotation.UP) {
            side = Direction.DOWN;
        }
        return this.rotate(state, side, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    public static BlockState mirrorPanel(BlockState state, Mirror mirror) {
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        if (newState != state && !rot.isVertical()) {
            state = (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot.getOpposite()));
        }
        return state;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskFront = 16;
        VoxelShape[] shapes = new VoxelShape[32];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shape = SHAPES.get(SlopePanelShape.get(rot, false));
            VoxelShape shapeFront = SHAPES.get(SlopePanelShape.get(rot, true));
            ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, shapes, rot.ordinal() << 2);
            ShapeUtils.makeHorizontalRotations(shapeFront, Direction.NORTH, shapes, maskFront | rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int front = (Boolean)state.getValue((Property)PropertyHolder.FRONT) != false ? maskFront : 0;
            int idx = dir.get2DDataValue() | rot.ordinal() << 2 | front;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

