/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatSlopePanelCornerBlock
extends FramedBlock {
    public static final ShapeCache<ShapeKey> SHAPES = ShapeCache.create(map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = ShapeUtils.andUnoptimized(FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.get(rot, false)), FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.get(rot.rotate(Rotation.COUNTERCLOCKWISE_90), false)));
            map.put(new ShapeKey(rot, false), preShape);
            map.put(new ShapeKey(rot, true), preShape.move(0.0, 0.0, 0.5));
        }
    });
    public static final ShapeCache<ShapeKey> INNER_SHAPES = ShapeCache.create(map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = ShapeUtils.orUnoptimized(FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.get(rot, false)), FramedSlopePanelBlock.SHAPES.get(SlopePanelShape.get(rot.rotate(Rotation.COUNTERCLOCKWISE_90), false)));
            map.put(new ShapeKey(rot, false), preShape);
            map.put(new ShapeKey(rot, true), preShape.move(0.0, 0.0, 0.5));
        }
    });

    public FramedFlatSlopePanelCornerBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedFlatSlopePanelCornerBlock.getStateForPlacement(this, true, context);
    }

    public static BlockState getStateForPlacement(Block block, boolean hasFront, BlockPlaceContext context) {
        ExtPlacementStateBuilder builder = ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(block, context).withHorizontalFacing()).withCornerOrSideRotation();
        if (hasFront) {
            builder = builder.withFront();
        }
        return ((ExtPlacementStateBuilder)builder.tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction face = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        if (face == rotDir || face == perpRotDir) {
            if (this.getBlockType() == BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER) {
                face = dir.getOpposite();
            } else {
                double vert;
                Direction perpDir;
                double hor;
                Vec3 vec = Utils.fraction(hit.getLocation());
                double d = hor = Utils.isX(dir) ? vec.x() : vec.z();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                if (!((Boolean)state.getValue((Property)PropertyHolder.FRONT)).booleanValue()) {
                    hor -= 0.5;
                }
                Direction direction = perpDir = face == rotDir ? perpRotDir : rotDir;
                double d2 = Utils.isY(perpDir) ? vec.y() : (vert = Utils.isX(dir) ? vec.z() : vec.x());
                if (perpDir == Direction.DOWN || !Utils.isY(perpDir) && !Utils.isPositive(perpDir)) {
                    vert = 1.0 - vert;
                }
                if (hor * 2.0 < vert) {
                    face = dir.getOpposite();
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        if (face.getAxis() == dir.getAxis()) {
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)PropertyHolder.FRONT);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedFlatSlopePanelCornerBlock.mirrorCorner(state, mirror);
    }

    public static BlockState mirrorCorner(BlockState state, Mirror mirror) {
        BlockState newState = Utils.mirrorFaceBlock(state, mirror);
        if (newState != state) {
            HorizontalRotation rot;
            boolean vert = (rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION))).isVertical();
            rot = rot.rotate(vert ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90);
            return (BlockState)newState.setValue(PropertyHolder.ROTATION, (Comparable)((Object)rot));
        }
        return state;
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)HorizontalRotation.RIGHT));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskFront = 4;
        VoxelShape[] shapes = new VoxelShape[32];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = SHAPES.get(new ShapeKey(rot, false));
            VoxelShape preShapeFront = SHAPES.get(new ShapeKey(rot, true));
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 3);
            ShapeUtils.makeHorizontalRotations(preShapeFront, Direction.NORTH, shapes, maskFront | rot.ordinal() << 3);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int front = (Boolean)state.getValue((Property)PropertyHolder.FRONT) != false ? maskFront : 0;
            int idx = dir.get2DDataValue() | front | rot.ordinal() << 3;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskFront = 4;
        VoxelShape[] shapes = new VoxelShape[32];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = INNER_SHAPES.get(new ShapeKey(rot, false));
            VoxelShape preShapeFront = INNER_SHAPES.get(new ShapeKey(rot, true));
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                int idx = dir.get2DDataValue() | rot.ordinal() << 3;
                shapes[idx] = ShapeUtils.rotateShapeAroundY(Direction.NORTH, dir, preShape);
                idx = dir.get2DDataValue() | maskFront | rot.ordinal() << 3;
                shapes[idx] = ShapeUtils.rotateShapeAroundY(Direction.NORTH, dir, preShapeFront);
            }
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int front = (Boolean)state.getValue((Property)PropertyHolder.FRONT) != false ? maskFront : 0;
            int idx = dir.get2DDataValue() | front | rot.ordinal() << 3;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public record ShapeKey(HorizontalRotation rot, boolean front) {
    }
}

