/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeedge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.IComplexSlopeSource;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedSlopeEdgeBlock
extends FramedBlock
implements IComplexSlopeSource {
    public static final ShapeCache<ShapeKey> SHAPES = ShapeCache.create(map -> {
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedSlopeEdgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.25, (double)8.0), FramedSlopeEdgeBlock.box((double)0.0, (double)0.25, (double)0.0, (double)16.0, (double)4.0, (double)7.75), FramedSlopeEdgeBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)7.75, (double)4.0), FramedSlopeEdgeBlock.box((double)0.0, (double)7.75, (double)0.0, (double)16.0, (double)8.0, (double)0.25));
        map.put(new ShapeKey(SlopeType.BOTTOM, false), shapeBottom);
        map.put(new ShapeKey(SlopeType.BOTTOM, true), shapeBottom.move(0.0, 0.5, 0.5));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedSlopeEdgeBlock.box((double)0.0, (double)15.75, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedSlopeEdgeBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.75, (double)7.75), FramedSlopeEdgeBlock.box((double)0.0, (double)8.25, (double)0.0, (double)16.0, (double)12.0, (double)4.0), FramedSlopeEdgeBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)8.25, (double)0.25));
        map.put(new ShapeKey(SlopeType.TOP, false), shapeTop);
        map.put(new ShapeKey(SlopeType.TOP, true), shapeTop.move(0.0, -0.5, 0.5));
        VoxelShape shapeHorizontal = ShapeUtils.orUnoptimized(FramedSlopeEdgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)16.0, (double)8.0), FramedSlopeEdgeBlock.box((double)0.25, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.75), FramedSlopeEdgeBlock.box((double)4.0, (double)0.0, (double)0.0, (double)7.75, (double)16.0, (double)4.0), FramedSlopeEdgeBlock.box((double)7.75, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)0.25));
        map.put(new ShapeKey(SlopeType.HORIZONTAL, false), shapeHorizontal);
        map.put(new ShapeKey(SlopeType.HORIZONTAL, true), shapeHorizontal.move(0.5, 0.0, 0.5));
    });

    public FramedSlopeEdgeBlock() {
        super(BlockType.FRAMED_SLOPE_EDGE);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.ALT_TYPE, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, PropertyHolder.ALT_TYPE, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndSlopeType().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.getOpposite()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE && face == dir) {
            return (BlockState)state.cycle(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    @Override
    public boolean isHorizontalSlope(BlockState state) {
        return state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL;
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] shapes = new VoxelShape[24];
        for (SlopeType type : SlopeType.values()) {
            ShapeUtils.makeHorizontalRotations(SHAPES.get(new ShapeKey(type, false)), Direction.NORTH, shapes, type, (dir, keyType) -> FramedSlopeEdgeBlock.makeShapeIndex(dir, keyType, false));
            ShapeUtils.makeHorizontalRotations(SHAPES.get(new ShapeKey(type, true)), Direction.NORTH, shapes, type, (dir, keyType) -> FramedSlopeEdgeBlock.makeShapeIndex(dir, keyType, true));
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            SlopeType type;
            type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
            Direction dir2 = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean altType = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
            builder.put((Object)state, (Object)shapes[FramedSlopeEdgeBlock.makeShapeIndex(dir2, type, altType)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static int makeShapeIndex(Direction dir, SlopeType type, boolean altType) {
        return type.ordinal() << 3 | dir.get2DDataValue() << 1 | (altType ? 1 : 0);
    }

    public record ShapeKey(SlopeType type, boolean altType) {
    }
}

