/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopeedge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.IComplexSlopeSource;
import xfacthd.framedblocks.common.block.slopeedge.FramedSlopeEdgeBlock;
import xfacthd.framedblocks.common.block.stairs.vertical.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;

public class FramedElevatedSlopeEdgeBlock
extends FramedBlock
implements IComplexSlopeSource {
    public FramedElevatedSlopeEdgeBlock() {
        super(BlockType.FRAMED_ELEVATED_SLOPE_EDGE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, FramedProperties.SOLID, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndSlopeType().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        Direction face = hit.getDirection();
        if (hit.getDirection() == dir.getOpposite()) {
            Direction coordDir;
            switch ((SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE))) {
                default: {
                    throw new MatchException(null, null);
                }
                case BOTTOM: {
                    Direction direction = Direction.UP;
                    break;
                }
                case HORIZONTAL: {
                    Direction direction = dir.getClockWise();
                    break;
                }
                case TOP: {
                    Direction direction = coordDir = Direction.DOWN;
                }
            }
            if (Utils.fractionInDir(hit.getLocation(), coordDir) < 0.5) {
                face = dir;
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.getOpposite()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE && face == dir) {
            return (BlockState)state.cycle(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    @Override
    public boolean isHorizontalSlope(BlockState state) {
        return state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL;
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(ShapeUtils.orUnoptimized(FramedElevatedSlopeEdgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), FramedElevatedSlopeEdgeBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)), FramedSlopeEdgeBlock.SHAPES.get(new FramedSlopeEdgeBlock.ShapeKey(SlopeType.BOTTOM, true)));
        VoxelShape shapeHorizontal = ShapeUtils.orUnoptimized(FramedVerticalStairsBlock.SHAPES.get(new FramedVerticalStairsBlock.ShapeKey(Direction.NORTH, StairsType.VERTICAL)), FramedSlopeEdgeBlock.SHAPES.get(new FramedSlopeEdgeBlock.ShapeKey(SlopeType.HORIZONTAL, true)));
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(ShapeUtils.orUnoptimized(FramedElevatedSlopeEdgeBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedElevatedSlopeEdgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0)), FramedSlopeEdgeBlock.SHAPES.get(new FramedSlopeEdgeBlock.ShapeKey(SlopeType.TOP, true)));
        VoxelShape[] shapes = new VoxelShape[12];
        ShapeUtils.makeHorizontalRotations(shapeBottom, Direction.NORTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeHorizontal, Direction.NORTH, shapes, SlopeType.HORIZONTAL.ordinal() << 2);
        ShapeUtils.makeHorizontalRotations(shapeTop, Direction.NORTH, shapes, SlopeType.TOP.ordinal() << 2);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            int idx = (type.ordinal() << 2) + dir.get2DDataValue();
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

