/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedThreewayCornerBlock
extends FramedBlock {
    public FramedThreewayCornerBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withHalfFacing()).withTop()).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face) || face == dir.getOpposite() || face == dir.getClockWise()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if ((face == dir || face == dir.getCounterClockWise()) && rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)FramedProperties.TOP);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }

    public static ShapeProvider generateThreewayShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.box((double)0.0, (double)15.5, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)15.5), FramedThreewayCornerBlock.box((double)0.0, (double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.box((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.box((double)0.0, (double)0.5, (double)0.0, (double)4.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)4.0, (double)0.5), FramedThreewayCornerBlock.box((double)4.0, (double)12.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.box((double)4.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.box((double)8.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedThreewayCornerBlock.box((double)8.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.box((double)12.0, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedThreewayCornerBlock.box((double)12.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5));
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)15.5), FramedThreewayCornerBlock.box((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.box((double)0.0, (double)12.0, (double)0.0, (double)0.5, (double)16.0, (double)0.5), FramedThreewayCornerBlock.box((double)0.0, (double)12.0, (double)0.0, (double)4.0, (double)15.5, (double)4.0), FramedThreewayCornerBlock.box((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.box((double)4.0, (double)4.0, (double)0.0, (double)8.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.box((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0), FramedThreewayCornerBlock.box((double)8.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.box((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)4.0), FramedThreewayCornerBlock.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerThreewayShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)15.5), FramedThreewayCornerBlock.box((double)0.0, (double)12.0, (double)15.5, (double)15.5, (double)16.0, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), FramedThreewayCornerBlock.box((double)12.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedThreewayCornerBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedThreewayCornerBlock.box((double)0.0, (double)4.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)15.5, (double)0.5, (double)4.0), FramedThreewayCornerBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5), FramedThreewayCornerBlock.box((double)0.0, (double)0.5, (double)4.0, (double)4.0, (double)4.0, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)0.5, (double)15.5), FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)15.5, (double)0.5, (double)0.5, (double)16.0), FramedThreewayCornerBlock.box((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0, (double)12.0), FramedThreewayCornerBlock.box((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)8.0));
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)15.5), FramedThreewayCornerBlock.box((double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)4.0, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), FramedThreewayCornerBlock.box((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedThreewayCornerBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedThreewayCornerBlock.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)12.0, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), FramedThreewayCornerBlock.box((double)0.0, (double)15.5, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedThreewayCornerBlock.box((double)15.5, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5), FramedThreewayCornerBlock.box((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)15.5, (double)16.0), FramedThreewayCornerBlock.box((double)0.0, (double)15.5, (double)4.0, (double)4.0, (double)16.0, (double)15.5), FramedThreewayCornerBlock.box((double)0.0, (double)15.5, (double)15.5, (double)0.5, (double)16.0, (double)16.0), FramedThreewayCornerBlock.box((double)4.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0), FramedThreewayCornerBlock.box((double)8.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0));
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeBottom, shapeTop, Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

