/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.FramedUtils;

public class FramedSlopeBlock
extends FramedBlock
implements ISlopeBlock {
    public static final ShapeCache<SlopeType> SHAPES = ShapeCache.createEnum(SlopeType.class, map -> {
        map.put(SlopeType.BOTTOM, ShapeUtils.orUnoptimized(FramedSlopeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedSlopeBlock.box((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)15.5), FramedSlopeBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)12.0), FramedSlopeBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0), FramedSlopeBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)4.0), FramedSlopeBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)0.5)));
        map.put(SlopeType.TOP, ShapeUtils.orUnoptimized(FramedSlopeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)0.5), FramedSlopeBlock.box((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)4.0), FramedSlopeBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), FramedSlopeBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)12.0), FramedSlopeBlock.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)15.5), FramedSlopeBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));
        map.put(SlopeType.HORIZONTAL, ShapeUtils.orUnoptimized(FramedSlopeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedSlopeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)15.5), FramedSlopeBlock.box((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)12.0), FramedSlopeBlock.box((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0), FramedSlopeBlock.box((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)4.0), FramedSlopeBlock.box((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)));
    });
    private static final ShapeCache<ShapeKey> FINAL_SHAPES = ShapeCache.create(map -> {
        for (SlopeType type : SlopeType.values()) {
            ShapeUtils.makeHorizontalRotations(SHAPES.get(type), Direction.NORTH, map, type, ShapeKey::new);
        }
    });

    public FramedSlopeBlock() {
        super(BlockType.FRAMED_SLOPE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndSlopeType().withWater()).build();
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!stack.isEmpty() && FramedUtils.isRailItem(stack.getItem())) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
            Direction face = hit.getDirection();
            if (type == SlopeType.BOTTOM && (face == dir.getOpposite() || face == Direction.UP)) {
                Block railSlope = FramedUtils.getRailSlopeBlock(stack.getItem());
                BlockState newState = (BlockState)((BlockState)railSlope.defaultBlockState().setValue(PropertyHolder.ASCENDING_RAIL_SHAPE, (Comparable)FramedUtils.getAscendingRailShapeFromDirection(dir))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)));
                if (!newState.canSurvive((LevelReader)level, pos)) {
                    return ItemInteractionResult.FAIL;
                }
                if (!level.isClientSide()) {
                    Utils.wrapInStateCopy((LevelAccessor)level, pos, player, stack, false, true, () -> level.setBlockAndUpdate(pos, newState));
                    SoundType sound = Blocks.RAIL.defaultBlockState().getSoundType();
                    level.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.getOpposite()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE && face == dir) {
            return (BlockState)state.cycle(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public SlopeType getSlopeType(BlockState state) {
        return (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            ISlopeBlock block = (ISlopeBlock)state.getBlock();
            SlopeType type = block.getSlopeType(state);
            Direction dir = block.getFacing(state);
            builder.put((Object)state, (Object)FINAL_SHAPES.get(new ShapeKey(dir, type)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private record ShapeKey(Direction dir, SlopeType type) {
    }
}

