/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPyramidBlock
extends FramedBlock {
    public FramedPyramidBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.UP)).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING, FramedProperties.SOLID, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetFacing(true)).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        return (BlockState)state.cycle((Property)BlockStateProperties.FACING);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = rot.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING));
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)dir);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.FACING, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedPyramidBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedPyramidBlock.box((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)4.0, (double)15.5), FramedPyramidBlock.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), FramedPyramidBlock.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedPyramidBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.box((double)0.5, (double)12.0, (double)0.5, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), FramedPyramidBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), FramedPyramidBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
        VoxelShape shapeNorth = ShapeUtils.orUnoptimized(FramedPyramidBlock.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.box((double)0.5, (double)0.5, (double)12.0, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.box((double)2.0, (double)2.0, (double)8.0, (double)14.0, (double)14.0, (double)12.0), FramedPyramidBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)8.0), FramedPyramidBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
        VoxelShape[] horShapes = ShapeUtils.makeHorizontalRotations(shapeNorth, Direction.NORTH);
        for (BlockState state : states) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            VoxelShape shape = switch (facing) {
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
                default -> horShapes[facing.get2DDataValue()];
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateSlabShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        VoxelShape shapeUp = ShapeUtils.orUnoptimized(FramedPyramidBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedPyramidBlock.box((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)2.0, (double)15.5), FramedPyramidBlock.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), FramedPyramidBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), FramedPyramidBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0));
        VoxelShape shapeDown = ShapeUtils.orUnoptimized(FramedPyramidBlock.box((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.box((double)0.5, (double)14.0, (double)0.5, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), FramedPyramidBlock.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));
        VoxelShape shapeNorth = ShapeUtils.orUnoptimized(FramedPyramidBlock.box((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), FramedPyramidBlock.box((double)0.5, (double)0.5, (double)14.0, (double)15.5, (double)15.5, (double)15.5), FramedPyramidBlock.box((double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0), FramedPyramidBlock.box((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)12.0), FramedPyramidBlock.box((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)10.0));
        VoxelShape[] horShapes = ShapeUtils.makeHorizontalRotations(shapeNorth, Direction.NORTH);
        for (BlockState state : states) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            VoxelShape shape = switch (facing) {
                case Direction.UP -> shapeUp;
                case Direction.DOWN -> shapeDown;
                default -> horShapes[facing.get2DDataValue()];
            };
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

