/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slope.FramedSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedHalfSlopeBlock
extends FramedBlock {
    public static final ShapeCache<ShapeKey> SHAPES = ShapeCache.create(map -> {
        map.put(new ShapeKey(false, false), ShapeUtils.andUnoptimized(FramedSlopeBlock.SHAPES.get(SlopeType.BOTTOM), CommonShapes.PANEL.get(Direction.WEST)));
        map.put(new ShapeKey(false, true), ShapeUtils.andUnoptimized(FramedSlopeBlock.SHAPES.get(SlopeType.BOTTOM), CommonShapes.PANEL.get(Direction.EAST)));
        map.put(new ShapeKey(true, false), ShapeUtils.andUnoptimized(FramedSlopeBlock.SHAPES.get(SlopeType.TOP), CommonShapes.PANEL.get(Direction.WEST)));
        map.put(new ShapeKey(true, true), ShapeUtils.andUnoptimized(FramedSlopeBlock.SHAPES.get(SlopeType.TOP), CommonShapes.PANEL.get(Direction.EAST)));
    });

    public FramedHalfSlopeBlock() {
        super(BlockType.FRAMED_HALF_SLOPE);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, PropertyHolder.RIGHT, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacing()).withTop()).withRight().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face) || face == facing.getOpposite()) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(facing));
        }
        if (face == facing) {
            return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
        }
        return (BlockState)state.cycle((Property)FramedProperties.TOP);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite());
        }
        return (BlockState)state.cycle((Property)PropertyHolder.RIGHT);
    }

    @Override
    public BlockItem createBlockItem() {
        return new VerticalAndWallBlockItem(this, (Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE.value(), new Item.Properties());
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskTop = 4;
        int maskRight = 8;
        VoxelShape[] shapes = new VoxelShape[16];
        for (int i = 0; i < 4; ++i) {
            ShapeUtils.makeHorizontalRotations(SHAPES.get(new ShapeKey((i & 1) != 0, (i & 2) != 0)), Direction.NORTH, shapes, i << 2);
        }
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            int top = (Boolean)state.getValue((Property)FramedProperties.TOP) != false ? maskTop : 0;
            int right = (Boolean)state.getValue((Property)PropertyHolder.RIGHT) != false ? maskRight : 0;
            int idx = dir.get2DDataValue() | (top | right);
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public record ShapeKey(boolean top, boolean right) {
    }
}

