/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.blockentity.doubled.slope.FramedDoubleSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedDoubleSlopeBlock
extends AbstractFramedDoubleBlock {
    public FramedDoubleSlopeBlock() {
        super(BlockType.FRAMED_DOUBLE_SLOPE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndSlopeType().build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (state.getValue(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_SLOPE.value()).defaultBlockState();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)defState.setValue(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)type))).setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)defState.setValue(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)(type == SlopeType.HORIZONTAL ? type : type.getOpposite())))).setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return switch ((SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE))) {
            default -> throw new MatchException(null, null);
            case SlopeType.BOTTOM -> DoubleBlockTopInteractionMode.SECOND;
            case SlopeType.TOP -> DoubleBlockTopInteractionMode.FIRST;
            case SlopeType.HORIZONTAL -> DoubleBlockTopInteractionMode.EITHER;
        };
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SlopeType.HORIZONTAL -> {
                if (FramedDoubleSlopeBlock.matchesHor(side, facing) || Utils.isY(side) && FramedDoubleSlopeBlock.matchesHor(edge, facing)) {
                    yield CamoGetter.FIRST;
                }
                Direction oppFacing = facing.getOpposite();
                if (FramedDoubleSlopeBlock.matchesHor(side, oppFacing) || Utils.isY(side) && FramedDoubleSlopeBlock.matchesHor(edge, oppFacing)) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case SlopeType.TOP -> {
                if (side.getAxis() == facing.getClockWise().getAxis()) {
                    if (edge == facing || edge == Direction.UP) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.getOpposite() || edge == Direction.DOWN) {
                        yield CamoGetter.SECOND;
                    }
                    yield CamoGetter.NONE;
                }
                if (side == facing || side == Direction.UP) {
                    yield CamoGetter.FIRST;
                }
                if (side == facing.getOpposite() || side == Direction.DOWN) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case SlopeType.BOTTOM -> {
                if (side.getAxis() == facing.getClockWise().getAxis()) {
                    if (edge == facing || edge == Direction.DOWN) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.getOpposite() || edge == Direction.UP) {
                        yield CamoGetter.SECOND;
                    }
                    yield CamoGetter.NONE;
                }
                yield side == facing || side == Direction.DOWN ? CamoGetter.FIRST : (side == facing.getOpposite() || side == Direction.UP ? CamoGetter.SECOND : CamoGetter.NONE);
            }
        };
    }

    private static boolean matchesHor(Direction side, Direction facing) {
        return side == facing || side == facing.getCounterClockWise();
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SlopeType.HORIZONTAL -> {
                if (side == facing || side == facing.getCounterClockWise()) {
                    yield SolidityCheck.FIRST;
                }
                if (side == facing.getOpposite() || side == facing.getClockWise()) {
                    yield SolidityCheck.SECOND;
                }
                yield SolidityCheck.BOTH;
            }
            case SlopeType.TOP -> {
                if (side == facing || side == Direction.UP) {
                    yield SolidityCheck.FIRST;
                }
                if (side == facing.getOpposite() || side == Direction.DOWN) {
                    yield SolidityCheck.SECOND;
                }
                yield SolidityCheck.BOTH;
            }
            case SlopeType.BOTTOM -> side == facing || side == Direction.UP ? SolidityCheck.SECOND : (side == facing.getOpposite() || side == Direction.DOWN ? SolidityCheck.FIRST : SolidityCheck.BOTH);
        };
    }

    @Override
    public final BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleSlopeBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST)).setValue(PropertyHolder.SLOPE_TYPE, (Comparable)((Object)SlopeType.HORIZONTAL));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

