/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.ExtPlacementStateBuilder;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slope.FramedSlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedCornerSlopeBlock
extends FramedBlock {
    public FramedCornerSlopeBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.CORNER_TYPE, BlockStateProperties.WATERLOGGED, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((ExtPlacementStateBuilder)ExtPlacementStateBuilder.of(this, ctx).withHorizontalFacingAndCornerType().withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        if (type.isHorizontal()) {
            return (BlockState)state.setValue(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.rotate(rot)));
        }
        return this.rotate(state, rot);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = rot.rotate((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        if (type.isHorizontal()) {
            BlockState newState = Utils.mirrorFaceBlock(state, mirror);
            if (newState != state) {
                return (BlockState)newState.setValue(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.horizontalOpposite()));
            }
            return state;
        }
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.WEST);
    }

    public static ShapeProvider generateCornerShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeSlopeBottom = FramedSlopeBlock.SHAPES.get(SlopeType.BOTTOM);
        VoxelShape shapeSlopeTop = FramedSlopeBlock.SHAPES.get(SlopeType.TOP);
        VoxelShape shapeSlopeHorizontal = FramedSlopeBlock.SHAPES.get(SlopeType.HORIZONTAL);
        VoxelShape shapeSlopeHorizontalEast = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, shapeSlopeHorizontal);
        VoxelShape shapeTop = ShapeUtils.andUnoptimized(shapeSlopeTop, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeTop));
        VoxelShape shapeBottom = ShapeUtils.andUnoptimized(shapeSlopeBottom, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeBottom));
        VoxelShape shapeBottomLeft = ShapeUtils.andUnoptimized(shapeSlopeBottom, shapeSlopeHorizontal);
        VoxelShape shapeBottomRight = ShapeUtils.andUnoptimized(shapeSlopeBottom, shapeSlopeHorizontalEast);
        VoxelShape shapeTopLeft = ShapeUtils.andUnoptimized(shapeSlopeTop, shapeSlopeHorizontal);
        VoxelShape shapeTopRight = ShapeUtils.andUnoptimized(shapeSlopeTop, shapeSlopeHorizontalEast);
        HashMap shapes = new HashMap();
        for (CornerType type : CornerType.values()) {
            VoxelShape shape = switch (type) {
                default -> throw new MatchException(null, null);
                case CornerType.BOTTOM -> shapeBottom;
                case CornerType.TOP -> shapeTop;
                case CornerType.HORIZONTAL_BOTTOM_LEFT -> shapeBottomLeft;
                case CornerType.HORIZONTAL_BOTTOM_RIGHT -> shapeBottomRight;
                case CornerType.HORIZONTAL_TOP_LEFT -> shapeTopLeft;
                case CornerType.HORIZONTAL_TOP_RIGHT -> shapeTopRight;
            };
            ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, shapes, type, ShapeKey::new);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerType type;
            type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)((VoxelShape)shapes.get(new ShapeKey(dir, type))));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerCornerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeSlopeBottom = FramedSlopeBlock.SHAPES.get(SlopeType.BOTTOM);
        VoxelShape shapeSlopeTop = FramedSlopeBlock.SHAPES.get(SlopeType.TOP);
        VoxelShape shapeSlopeHorizontal = FramedSlopeBlock.SHAPES.get(SlopeType.HORIZONTAL);
        VoxelShape shapeSlopeHorizontalEast = ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.EAST, shapeSlopeHorizontal);
        VoxelShape shapeTop = ShapeUtils.orUnoptimized(shapeSlopeTop, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeTop));
        VoxelShape shapeBottom = ShapeUtils.orUnoptimized(shapeSlopeBottom, ShapeUtils.rotateShapeUnoptimizedAroundY(Direction.NORTH, Direction.WEST, shapeSlopeBottom));
        VoxelShape shapeBottomLeft = ShapeUtils.orUnoptimized(shapeSlopeBottom, shapeSlopeHorizontal);
        VoxelShape shapeBottomRight = ShapeUtils.orUnoptimized(shapeSlopeBottom, shapeSlopeHorizontalEast);
        VoxelShape shapeTopLeft = ShapeUtils.orUnoptimized(shapeSlopeTop, shapeSlopeHorizontal);
        VoxelShape shapeTopRight = ShapeUtils.orUnoptimized(shapeSlopeTop, shapeSlopeHorizontalEast);
        HashMap shapes = new HashMap();
        for (CornerType type : CornerType.values()) {
            VoxelShape shape = switch (type) {
                default -> throw new MatchException(null, null);
                case CornerType.BOTTOM -> shapeBottom;
                case CornerType.TOP -> shapeTop;
                case CornerType.HORIZONTAL_BOTTOM_LEFT -> shapeBottomLeft;
                case CornerType.HORIZONTAL_BOTTOM_RIGHT -> shapeBottomRight;
                case CornerType.HORIZONTAL_TOP_LEFT -> shapeTopLeft;
                case CornerType.HORIZONTAL_TOP_RIGHT -> shapeTopRight;
            };
            ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, shapes, type, ShapeKey::new);
        }
        for (BlockState state : states) {
            CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)((VoxelShape)shapes.get(new ShapeKey(dir, type))));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private record ShapeKey(Direction dir, CornerType type) {
    }
}

