/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedCheckeredCubeSegmentBlock
extends FramedBlock {
    public FramedCheckeredCubeSegmentBlock() {
        super(BlockType.FRAMED_CHECKERED_CUBE_SEGMENT);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.SECOND, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.SECOND, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> (BlockState)state.setValue((Property)PropertyHolder.SECOND, (Comparable)Boolean.valueOf(Utils.isX(ctx.getHorizontalDirection()))))).withWater()).build();
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        if (rot != Rotation.NONE && rot != Rotation.CLOCKWISE_180) {
            return (BlockState)state.cycle((Property)PropertyHolder.SECOND);
        }
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        if (mirror != Mirror.NONE) {
            return (BlockState)state.cycle((Property)PropertyHolder.SECOND);
        }
        return state;
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return state;
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeFirst = ShapeUtils.or(FramedCheckeredCubeSegmentBlock.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), FramedCheckeredCubeSegmentBlock.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), FramedCheckeredCubeSegmentBlock.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), FramedCheckeredCubeSegmentBlock.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0));
        VoxelShape shapeSecond = ShapeUtils.rotateShapeAroundY(Direction.NORTH, Direction.EAST, shapeFirst);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = states.iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            boolean second = (Boolean)(state = (BlockState)unmodifiableIterator.next()).getValue((Property)PropertyHolder.SECOND);
            builder.put((Object)state, (Object)(second ? shapeSecond : shapeFirst));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

