/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWallSignBlock
extends AbstractFramedSignBlock {
    private static final Vec3[] HITBOX_CENTERS = (Vec3[])Util.make((Object)new Vec3[4], arr -> {
        arr[Direction.NORTH.get2DDataValue()] = new Vec3(0.5, 0.5, 0.9375);
        arr[Direction.EAST.get2DDataValue()] = new Vec3(0.0625, 0.5, 0.5);
        arr[Direction.SOUTH.get2DDataValue()] = new Vec3(0.5, 0.5, 0.0625);
        arr[Direction.WEST.get2DDataValue()] = new Vec3(0.9375, 0.5, 0.5);
    });

    public FramedWallSignBlock() {
        super(BlockType.FRAMED_WALL_SIGN, IFramedBlock.createProperties(BlockType.FRAMED_WALL_SIGN).noCollission());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            Direction[] dirs;
            Level level = modCtx.getLevel();
            BlockPos pos = modCtx.getClickedPos();
            for (Direction direction : dirs = modCtx.getNearestLookingDirections()) {
                Direction dir;
                if (!direction.getAxis().isHorizontal() || !(state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)(dir = direction.getOpposite()))).canSurvive((LevelReader)level, pos)) continue;
                return state;
            }
            return null;
        })).withWater()).build();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction dir, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (dir.getOpposite() == state.getValue((Property)FramedProperties.FACING_HOR) && !state.canSurvive((LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, dir, facingState, level, pos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)).getOpposite();
        return level.getBlockState(pos.relative(dir)).isSolid();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
    }

    @Override
    public float getYRotationDegrees(BlockState state) {
        return ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)).toYRot();
    }

    @Override
    public Vec3 getSignHitboxCenterPosition(BlockState state) {
        return HITBOX_CENTERS[((Direction)state.getValue((Property)FramedProperties.FACING_HOR)).get2DDataValue()];
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            switch ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)) {
                case NORTH: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.box((double)0.0, (double)4.5, (double)14.0, (double)16.0, (double)12.5, (double)16.0));
                    break;
                }
                case EAST: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.box((double)0.0, (double)4.5, (double)0.0, (double)2.0, (double)12.5, (double)16.0));
                    break;
                }
                case SOUTH: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.box((double)0.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)2.0));
                    break;
                }
                case WEST: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.box((double)14.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)16.0));
                }
            }
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

