/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.sign.AbstractFramedHangingSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedHangingSignItem;

public class FramedCeilingHangingSignBlock
extends AbstractFramedHangingSignBlock {
    public FramedCeilingHangingSignBlock() {
        super(BlockType.FRAMED_HANGING_SIGN, IFramedBlock.createProperties(BlockType.FRAMED_HANGING_SIGN).noCollission());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.ROTATION_16, BlockStateProperties.ATTACHED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            boolean attached;
            Level level = modCtx.getLevel();
            BlockPos adjPos = modCtx.getClickedPos().above();
            BlockState adjState = level.getBlockState(adjPos);
            Direction dir = Direction.fromYRot((double)modCtx.getRotation());
            boolean bl = attached = !Block.isFaceFull((VoxelShape)adjState.getCollisionShape((BlockGetter)level, adjPos), (Direction)Direction.DOWN) || modCtx.isSecondaryUseActive();
            if (adjState.getBlock() instanceof AbstractFramedHangingSignBlock && !modCtx.isSecondaryUseActive()) {
                int adjRot;
                Optional optDir;
                if (adjState.hasProperty((Property)FramedProperties.FACING_HOR)) {
                    Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
                    if (adjDir.getAxis().test(dir)) {
                        attached = false;
                    }
                } else if (adjState.hasProperty((Property)BlockStateProperties.ROTATION_16) && (optDir = RotationSegment.convertToDirection((int)(adjRot = ((Integer)adjState.getValue((Property)BlockStateProperties.ROTATION_16)).intValue()))).isPresent() && ((Direction)optDir.get()).getAxis().test(dir)) {
                    attached = false;
                }
            }
            int rotation = attached ? RotationSegment.convertToSegment((float)(modCtx.getRotation() + 180.0f)) : RotationSegment.convertToSegment((Direction)dir.getOpposite());
            return (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation))).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(attached));
        })).withWater()).build();
    }

    @Override
    protected boolean preventUse(BlockState state, Level level, BlockPos pos, Player player, ItemStack stack, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity sign = (FramedSignBlockEntity)blockEntity;
            boolean front = sign.isFacingFrontText(player);
            return sign.cannotExecuteCommands(front, player) && stack.getItem() == this.asItem() && hit.getDirection() == Direction.DOWN;
        }
        return false;
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction dir, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (dir == Direction.UP && !this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, dir, facingState, level, pos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos above = pos.above();
        return level.getBlockState(above).isFaceSturdy((BlockGetter)level, above, Direction.DOWN, SupportType.CENTER);
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, CollisionContext.empty());
    }

    @Override
    public float getYRotationDegrees(BlockState state) {
        return RotationSegment.convertToDegrees((int)((Integer)state.getValue((Property)BlockStateProperties.ROTATION_16)));
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        int rotation = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        rotation = rot == Rotation.COUNTERCLOCKWISE_90 ? (rotation += 15) : ++rotation;
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation % 16));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        int rotation = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot.rotate(rotation, 16)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        int rotation = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(mirror.mirror(rotation, 16)));
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return Utils.createBlockEntityTicker(type, (BlockEntityType)FBContent.BE_TYPE_FRAMED_HANGING_SIGN.value(), FramedSignBlockEntity::tick);
    }

    @Override
    public BlockItem createBlockItem() {
        return new FramedHangingSignItem();
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeZeroEight = FramedCeilingHangingSignBlock.box((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)10.0, (double)9.0);
        VoxelShape shapeFourTwelve = FramedCeilingHangingSignBlock.box((double)7.0, (double)0.0, (double)1.0, (double)9.0, (double)10.0, (double)15.0);
        VoxelShape fallbackShape = FramedCeilingHangingSignBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        for (BlockState state : states) {
            int rot = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
            builder.put((Object)state, (Object)(switch (rot) {
                case 0, 8 -> shapeZeroEight;
                case 4, 12 -> shapeFourTwelve;
                default -> fallbackShape;
            }));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

